/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ExpressionStatementNode
extends StatementNode {
    public ExpressionStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "semicolonToken"};
    }

    public ExpressionStatementNode modify(SyntaxKind kind, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createExpressionStatementNode(kind, expression, semicolonToken);
    }

    public ExpressionStatementNodeModifier modify() {
        return new ExpressionStatementNodeModifier(this);
    }

    public static class ExpressionStatementNodeModifier {
        private final ExpressionStatementNode oldNode;
        private ExpressionNode expression;
        private Token semicolonToken;

        public ExpressionStatementNodeModifier(ExpressionStatementNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ExpressionStatementNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ExpressionStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ExpressionStatementNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.expression, this.semicolonToken);
        }
    }
}

