/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ExternalFunctionBodyNode
extends FunctionBodyNode {
    public ExternalFunctionBodyNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token externalKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"equalsToken", "annotations", "externalKeyword", "semicolonToken"};
    }

    public ExternalFunctionBodyNode modify(Token equalsToken, NodeList<AnnotationNode> annotations, Token externalKeyword, Token semicolonToken) {
        if (this.checkForReferenceEquality(equalsToken, annotations.underlyingListNode(), externalKeyword, semicolonToken)) {
            return this;
        }
        return NodeFactory.createExternalFunctionBodyNode(equalsToken, annotations, externalKeyword, semicolonToken);
    }

    public ExternalFunctionBodyNodeModifier modify() {
        return new ExternalFunctionBodyNodeModifier(this);
    }

    public static class ExternalFunctionBodyNodeModifier {
        private final ExternalFunctionBodyNode oldNode;
        private Token equalsToken;
        private NodeList<AnnotationNode> annotations;
        private Token externalKeyword;
        private Token semicolonToken;

        public ExternalFunctionBodyNodeModifier(ExternalFunctionBodyNode oldNode) {
            this.oldNode = oldNode;
            this.equalsToken = oldNode.equalsToken();
            this.annotations = oldNode.annotations();
            this.externalKeyword = oldNode.externalKeyword();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ExternalFunctionBodyNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public ExternalFunctionBodyNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ExternalFunctionBodyNodeModifier withExternalKeyword(Token externalKeyword) {
            Objects.requireNonNull(externalKeyword, "externalKeyword must not be null");
            this.externalKeyword = externalKeyword;
            return this;
        }

        public ExternalFunctionBodyNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ExternalFunctionBodyNode apply() {
            return this.oldNode.modify(this.equalsToken, this.annotations, this.externalKeyword, this.semicolonToken);
        }
    }
}

