/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class FunctionSignatureNode
extends NonTerminalNode {
    public FunctionSignatureNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<ParameterNode> parameters() {
        return new SeparatedNodeList<ParameterNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(2);
    }

    public Optional<ReturnTypeDescriptorNode> returnTypeDesc() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "parameters", "closeParenToken", "returnTypeDesc"};
    }

    public FunctionSignatureNode modify(Token openParenToken, SeparatedNodeList<ParameterNode> parameters, Token closeParenToken, ReturnTypeDescriptorNode returnTypeDesc) {
        if (this.checkForReferenceEquality(openParenToken, parameters.underlyingListNode(), closeParenToken, returnTypeDesc)) {
            return this;
        }
        return NodeFactory.createFunctionSignatureNode(openParenToken, parameters, closeParenToken, returnTypeDesc);
    }

    public FunctionSignatureNodeModifier modify() {
        return new FunctionSignatureNodeModifier(this);
    }

    public static class FunctionSignatureNodeModifier {
        private final FunctionSignatureNode oldNode;
        private Token openParenToken;
        private SeparatedNodeList<ParameterNode> parameters;
        private Token closeParenToken;
        private ReturnTypeDescriptorNode returnTypeDesc;

        public FunctionSignatureNodeModifier(FunctionSignatureNode oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.parameters = oldNode.parameters();
            this.closeParenToken = oldNode.closeParenToken();
            this.returnTypeDesc = oldNode.returnTypeDesc().orElse(null);
        }

        public FunctionSignatureNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public FunctionSignatureNodeModifier withParameters(SeparatedNodeList<ParameterNode> parameters) {
            Objects.requireNonNull(parameters, "parameters must not be null");
            this.parameters = parameters;
            return this;
        }

        public FunctionSignatureNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public FunctionSignatureNodeModifier withReturnTypeDesc(ReturnTypeDescriptorNode returnTypeDesc) {
            this.returnTypeDesc = returnTypeDesc;
            return this;
        }

        public FunctionSignatureNode apply() {
            return this.oldNode.modify(this.openParenToken, this.parameters, this.closeParenToken, this.returnTypeDesc);
        }
    }
}

