/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class MatchStatementNode
extends StatementNode {
    public MatchStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token matchKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode condition() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(2);
    }

    public NodeList<MatchClauseNode> matchClauses() {
        return new NodeList<MatchClauseNode>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(4);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"matchKeyword", "condition", "openBrace", "matchClauses", "closeBrace", "onFailClause"};
    }

    public MatchStatementNode modify(Token matchKeyword, ExpressionNode condition, Token openBrace, NodeList<MatchClauseNode> matchClauses, Token closeBrace, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(matchKeyword, condition, openBrace, matchClauses.underlyingListNode(), closeBrace, onFailClause)) {
            return this;
        }
        return NodeFactory.createMatchStatementNode(matchKeyword, condition, openBrace, matchClauses, closeBrace, onFailClause);
    }

    public MatchStatementNodeModifier modify() {
        return new MatchStatementNodeModifier(this);
    }

    public static class MatchStatementNodeModifier {
        private final MatchStatementNode oldNode;
        private Token matchKeyword;
        private ExpressionNode condition;
        private Token openBrace;
        private NodeList<MatchClauseNode> matchClauses;
        private Token closeBrace;
        private OnFailClauseNode onFailClause;

        public MatchStatementNodeModifier(MatchStatementNode oldNode) {
            this.oldNode = oldNode;
            this.matchKeyword = oldNode.matchKeyword();
            this.condition = oldNode.condition();
            this.openBrace = oldNode.openBrace();
            this.matchClauses = oldNode.matchClauses();
            this.closeBrace = oldNode.closeBrace();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public MatchStatementNodeModifier withMatchKeyword(Token matchKeyword) {
            Objects.requireNonNull(matchKeyword, "matchKeyword must not be null");
            this.matchKeyword = matchKeyword;
            return this;
        }

        public MatchStatementNodeModifier withCondition(ExpressionNode condition) {
            Objects.requireNonNull(condition, "condition must not be null");
            this.condition = condition;
            return this;
        }

        public MatchStatementNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public MatchStatementNodeModifier withMatchClauses(NodeList<MatchClauseNode> matchClauses) {
            Objects.requireNonNull(matchClauses, "matchClauses must not be null");
            this.matchClauses = matchClauses;
            return this;
        }

        public MatchStatementNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public MatchStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public MatchStatementNode apply() {
            return this.oldNode.modify(this.matchKeyword, this.condition, this.openBrace, this.matchClauses, this.closeBrace, this.onFailClause);
        }
    }
}

