/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ModuleXMLNamespaceDeclarationNode
extends ModuleMemberDeclarationNode {
    public ModuleXMLNamespaceDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token xmlnsKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode namespaceuri() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Optional<Token> asKeyword() {
        return this.optionalChildInBucket(2);
    }

    public Optional<IdentifierToken> namespacePrefix() {
        return this.optionalChildInBucket(3);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"xmlnsKeyword", "namespaceuri", "asKeyword", "namespacePrefix", "semicolonToken"};
    }

    public ModuleXMLNamespaceDeclarationNode modify(Token xmlnsKeyword, ExpressionNode namespaceuri, Token asKeyword, IdentifierToken namespacePrefix, Token semicolonToken) {
        if (this.checkForReferenceEquality(xmlnsKeyword, namespaceuri, asKeyword, namespacePrefix, semicolonToken)) {
            return this;
        }
        return NodeFactory.createModuleXMLNamespaceDeclarationNode(xmlnsKeyword, namespaceuri, asKeyword, namespacePrefix, semicolonToken);
    }

    public ModuleXMLNamespaceDeclarationNodeModifier modify() {
        return new ModuleXMLNamespaceDeclarationNodeModifier(this);
    }

    public static class ModuleXMLNamespaceDeclarationNodeModifier {
        private final ModuleXMLNamespaceDeclarationNode oldNode;
        private Token xmlnsKeyword;
        private ExpressionNode namespaceuri;
        private Token asKeyword;
        private IdentifierToken namespacePrefix;
        private Token semicolonToken;

        public ModuleXMLNamespaceDeclarationNodeModifier(ModuleXMLNamespaceDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.xmlnsKeyword = oldNode.xmlnsKeyword();
            this.namespaceuri = oldNode.namespaceuri();
            this.asKeyword = oldNode.asKeyword().orElse(null);
            this.namespacePrefix = oldNode.namespacePrefix().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ModuleXMLNamespaceDeclarationNodeModifier withXmlnsKeyword(Token xmlnsKeyword) {
            Objects.requireNonNull(xmlnsKeyword, "xmlnsKeyword must not be null");
            this.xmlnsKeyword = xmlnsKeyword;
            return this;
        }

        public ModuleXMLNamespaceDeclarationNodeModifier withNamespaceuri(ExpressionNode namespaceuri) {
            Objects.requireNonNull(namespaceuri, "namespaceuri must not be null");
            this.namespaceuri = namespaceuri;
            return this;
        }

        public ModuleXMLNamespaceDeclarationNodeModifier withAsKeyword(Token asKeyword) {
            this.asKeyword = asKeyword;
            return this;
        }

        public ModuleXMLNamespaceDeclarationNodeModifier withNamespacePrefix(IdentifierToken namespacePrefix) {
            this.namespacePrefix = namespacePrefix;
            return this;
        }

        public ModuleXMLNamespaceDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ModuleXMLNamespaceDeclarationNode apply() {
            return this.oldNode.modify(this.xmlnsKeyword, this.namespaceuri, this.asKeyword, this.namespacePrefix, this.semicolonToken);
        }
    }
}

