/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class OnConflictClauseNode
extends ClauseNode {
    public OnConflictClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token conflictKeyword() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"onKeyword", "conflictKeyword", "expression"};
    }

    public OnConflictClauseNode modify(Token onKeyword, Token conflictKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(onKeyword, conflictKeyword, expression)) {
            return this;
        }
        return NodeFactory.createOnConflictClauseNode(onKeyword, conflictKeyword, expression);
    }

    public OnConflictClauseNodeModifier modify() {
        return new OnConflictClauseNodeModifier(this);
    }

    public static class OnConflictClauseNodeModifier {
        private final OnConflictClauseNode oldNode;
        private Token onKeyword;
        private Token conflictKeyword;
        private ExpressionNode expression;

        public OnConflictClauseNodeModifier(OnConflictClauseNode oldNode) {
            this.oldNode = oldNode;
            this.onKeyword = oldNode.onKeyword();
            this.conflictKeyword = oldNode.conflictKeyword();
            this.expression = oldNode.expression();
        }

        public OnConflictClauseNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public OnConflictClauseNodeModifier withConflictKeyword(Token conflictKeyword) {
            Objects.requireNonNull(conflictKeyword, "conflictKeyword must not be null");
            this.conflictKeyword = conflictKeyword;
            return this;
        }

        public OnConflictClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public OnConflictClauseNode apply() {
            return this.oldNode.modify(this.onKeyword, this.conflictKeyword, this.expression);
        }
    }
}

