/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OrderKeyNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class OrderByClauseNode
extends IntermediateClauseNode {
    public OrderByClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token orderKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token byKeyword() {
        return (Token)this.childInBucket(1);
    }

    public SeparatedNodeList<OrderKeyNode> orderKey() {
        return new SeparatedNodeList<OrderKeyNode>((NonTerminalNode)this.childInBucket(2));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"orderKeyword", "byKeyword", "orderKey"};
    }

    public OrderByClauseNode modify(Token orderKeyword, Token byKeyword, SeparatedNodeList<OrderKeyNode> orderKey) {
        if (this.checkForReferenceEquality(orderKeyword, byKeyword, orderKey.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createOrderByClauseNode(orderKeyword, byKeyword, orderKey);
    }

    public OrderByClauseNodeModifier modify() {
        return new OrderByClauseNodeModifier(this);
    }

    public static class OrderByClauseNodeModifier {
        private final OrderByClauseNode oldNode;
        private Token orderKeyword;
        private Token byKeyword;
        private SeparatedNodeList<OrderKeyNode> orderKey;

        public OrderByClauseNodeModifier(OrderByClauseNode oldNode) {
            this.oldNode = oldNode;
            this.orderKeyword = oldNode.orderKeyword();
            this.byKeyword = oldNode.byKeyword();
            this.orderKey = oldNode.orderKey();
        }

        public OrderByClauseNodeModifier withOrderKeyword(Token orderKeyword) {
            Objects.requireNonNull(orderKeyword, "orderKeyword must not be null");
            this.orderKeyword = orderKeyword;
            return this;
        }

        public OrderByClauseNodeModifier withByKeyword(Token byKeyword) {
            Objects.requireNonNull(byKeyword, "byKeyword must not be null");
            this.byKeyword = byKeyword;
            return this;
        }

        public OrderByClauseNodeModifier withOrderKey(SeparatedNodeList<OrderKeyNode> orderKey) {
            Objects.requireNonNull(orderKey, "orderKey must not be null");
            this.orderKey = orderKey;
            return this;
        }

        public OrderByClauseNode apply() {
            return this.oldNode.modify(this.orderKeyword, this.byKeyword, this.orderKey);
        }
    }
}

