/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class OrderKeyNode
extends NonTerminalNode {
    public OrderKeyNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Optional<Token> orderDirection() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "orderDirection"};
    }

    public OrderKeyNode modify(ExpressionNode expression, Token orderDirection) {
        if (this.checkForReferenceEquality(expression, orderDirection)) {
            return this;
        }
        return NodeFactory.createOrderKeyNode(expression, orderDirection);
    }

    public OrderKeyNodeModifier modify() {
        return new OrderKeyNodeModifier(this);
    }

    public static class OrderKeyNodeModifier {
        private final OrderKeyNode oldNode;
        private ExpressionNode expression;
        private Token orderDirection;

        public OrderKeyNodeModifier(OrderKeyNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.orderDirection = oldNode.orderDirection().orElse(null);
        }

        public OrderKeyNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public OrderKeyNodeModifier withOrderDirection(Token orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public OrderKeyNode apply() {
            return this.oldNode.modify(this.expression, this.orderDirection);
        }
    }
}

