/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class RecordFieldNode
extends NonTerminalNode {
    public RecordFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> readonlyKeyword() {
        return this.optionalChildInBucket(1);
    }

    public Node typeName() {
        return this.childInBucket(2);
    }

    public Token fieldName() {
        return (Token)this.childInBucket(3);
    }

    public Optional<Token> questionMarkToken() {
        return this.optionalChildInBucket(4);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "readonlyKeyword", "typeName", "fieldName", "questionMarkToken", "semicolonToken"};
    }

    public RecordFieldNode modify(MetadataNode metadata, Token readonlyKeyword, Node typeName, Token fieldName, Token questionMarkToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createRecordFieldNode(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken);
    }

    public RecordFieldNodeModifier modify() {
        return new RecordFieldNodeModifier(this);
    }

    public static class RecordFieldNodeModifier {
        private final RecordFieldNode oldNode;
        private MetadataNode metadata;
        private Token readonlyKeyword;
        private Node typeName;
        private Token fieldName;
        private Token questionMarkToken;
        private Token semicolonToken;

        public RecordFieldNodeModifier(RecordFieldNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.readonlyKeyword = oldNode.readonlyKeyword().orElse(null);
            this.typeName = oldNode.typeName();
            this.fieldName = oldNode.fieldName();
            this.questionMarkToken = oldNode.questionMarkToken().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public RecordFieldNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public RecordFieldNodeModifier withReadonlyKeyword(Token readonlyKeyword) {
            this.readonlyKeyword = readonlyKeyword;
            return this;
        }

        public RecordFieldNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public RecordFieldNodeModifier withFieldName(Token fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public RecordFieldNodeModifier withQuestionMarkToken(Token questionMarkToken) {
            this.questionMarkToken = questionMarkToken;
            return this;
        }

        public RecordFieldNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public RecordFieldNode apply() {
            return this.oldNode.modify(this.metadata, this.readonlyKeyword, this.typeName, this.fieldName, this.questionMarkToken, this.semicolonToken);
        }
    }
}

