/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class RequiredParameterNode
extends ParameterNode {
    public RequiredParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Node typeName() {
        return this.childInBucket(1);
    }

    public Optional<Token> paramName() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typeName", "paramName"};
    }

    public RequiredParameterNode modify(NodeList<AnnotationNode> annotations, Node typeName, Token paramName) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typeName, paramName)) {
            return this;
        }
        return NodeFactory.createRequiredParameterNode(annotations, typeName, paramName);
    }

    public RequiredParameterNodeModifier modify() {
        return new RequiredParameterNodeModifier(this);
    }

    public static class RequiredParameterNodeModifier {
        private final RequiredParameterNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Node typeName;
        private Token paramName;

        public RequiredParameterNodeModifier(RequiredParameterNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typeName = oldNode.typeName();
            this.paramName = oldNode.paramName().orElse(null);
        }

        public RequiredParameterNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public RequiredParameterNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public RequiredParameterNodeModifier withParamName(Token paramName) {
            this.paramName = paramName;
            return this;
        }

        public RequiredParameterNode apply() {
            return this.oldNode.modify(this.annotations, this.typeName, this.paramName);
        }
    }
}

