/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class StreamTypeParamsNode
extends NonTerminalNode {
    public StreamTypeParamsNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public Node leftTypeDescNode() {
        return this.childInBucket(1);
    }

    public Optional<Token> commaToken() {
        return this.optionalChildInBucket(2);
    }

    public Optional<Node> rightTypeDescNode() {
        return this.optionalChildInBucket(3);
    }

    public Token gtToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "leftTypeDescNode", "commaToken", "rightTypeDescNode", "gtToken"};
    }

    public StreamTypeParamsNode modify(Token ltToken, Node leftTypeDescNode, Token commaToken, Node rightTypeDescNode, Token gtToken) {
        if (this.checkForReferenceEquality(ltToken, leftTypeDescNode, commaToken, rightTypeDescNode, gtToken)) {
            return this;
        }
        return NodeFactory.createStreamTypeParamsNode(ltToken, leftTypeDescNode, commaToken, rightTypeDescNode, gtToken);
    }

    public StreamTypeParamsNodeModifier modify() {
        return new StreamTypeParamsNodeModifier(this);
    }

    public static class StreamTypeParamsNodeModifier {
        private final StreamTypeParamsNode oldNode;
        private Token ltToken;
        private Node leftTypeDescNode;
        private Token commaToken;
        private Node rightTypeDescNode;
        private Token gtToken;

        public StreamTypeParamsNodeModifier(StreamTypeParamsNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.leftTypeDescNode = oldNode.leftTypeDescNode();
            this.commaToken = oldNode.commaToken().orElse(null);
            this.rightTypeDescNode = oldNode.rightTypeDescNode().orElse(null);
            this.gtToken = oldNode.gtToken();
        }

        public StreamTypeParamsNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public StreamTypeParamsNodeModifier withLeftTypeDescNode(Node leftTypeDescNode) {
            Objects.requireNonNull(leftTypeDescNode, "leftTypeDescNode must not be null");
            this.leftTypeDescNode = leftTypeDescNode;
            return this;
        }

        public StreamTypeParamsNodeModifier withCommaToken(Token commaToken) {
            this.commaToken = commaToken;
            return this;
        }

        public StreamTypeParamsNodeModifier withRightTypeDescNode(Node rightTypeDescNode) {
            this.rightTypeDescNode = rightTypeDescNode;
            return this;
        }

        public StreamTypeParamsNodeModifier withGtToken(Token gtToken) {
            Objects.requireNonNull(gtToken, "gtToken must not be null");
            this.gtToken = gtToken;
            return this;
        }

        public StreamTypeParamsNode apply() {
            return this.oldNode.modify(this.ltToken, this.leftTypeDescNode, this.commaToken, this.rightTypeDescNode, this.gtToken);
        }
    }
}

