/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class SyncSendActionNode
extends ActionNode {
    public SyncSendActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token syncSendToken() {
        return (Token)this.childInBucket(1);
    }

    public SimpleNameReferenceNode peerWorker() {
        return (SimpleNameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "syncSendToken", "peerWorker"};
    }

    public SyncSendActionNode modify(ExpressionNode expression, Token syncSendToken, SimpleNameReferenceNode peerWorker) {
        if (this.checkForReferenceEquality(expression, syncSendToken, peerWorker)) {
            return this;
        }
        return NodeFactory.createSyncSendActionNode(expression, syncSendToken, peerWorker);
    }

    public SyncSendActionNodeModifier modify() {
        return new SyncSendActionNodeModifier(this);
    }

    public static class SyncSendActionNodeModifier {
        private final SyncSendActionNode oldNode;
        private ExpressionNode expression;
        private Token syncSendToken;
        private SimpleNameReferenceNode peerWorker;

        public SyncSendActionNodeModifier(SyncSendActionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.syncSendToken = oldNode.syncSendToken();
            this.peerWorker = oldNode.peerWorker();
        }

        public SyncSendActionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public SyncSendActionNodeModifier withSyncSendToken(Token syncSendToken) {
            Objects.requireNonNull(syncSendToken, "syncSendToken must not be null");
            this.syncSendToken = syncSendToken;
            return this;
        }

        public SyncSendActionNodeModifier withPeerWorker(SimpleNameReferenceNode peerWorker) {
            Objects.requireNonNull(peerWorker, "peerWorker must not be null");
            this.peerWorker = peerWorker;
            return this;
        }

        public SyncSendActionNode apply() {
            return this.oldNode.modify(this.expression, this.syncSendToken, this.peerWorker);
        }
    }
}

