/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class TypeofExpressionNode
extends ExpressionNode {
    public TypeofExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token typeofKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"typeofKeyword", "expression"};
    }

    public TypeofExpressionNode modify(Token typeofKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(typeofKeyword, expression)) {
            return this;
        }
        return NodeFactory.createTypeofExpressionNode(typeofKeyword, expression);
    }

    public TypeofExpressionNodeModifier modify() {
        return new TypeofExpressionNodeModifier(this);
    }

    public static class TypeofExpressionNodeModifier {
        private final TypeofExpressionNode oldNode;
        private Token typeofKeyword;
        private ExpressionNode expression;

        public TypeofExpressionNodeModifier(TypeofExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.typeofKeyword = oldNode.typeofKeyword();
            this.expression = oldNode.expression();
        }

        public TypeofExpressionNodeModifier withTypeofKeyword(Token typeofKeyword) {
            Objects.requireNonNull(typeofKeyword, "typeofKeyword must not be null");
            this.typeofKeyword = typeofKeyword;
            return this;
        }

        public TypeofExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public TypeofExpressionNode apply() {
            return this.oldNode.modify(this.typeofKeyword, this.expression);
        }
    }
}

