/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;
import java.util.Optional;

public class VariableDeclarationNode
extends StatementNode {
    public VariableDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Optional<Token> finalKeyword() {
        return this.optionalChildInBucket(1);
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(2);
    }

    public Optional<Token> equalsToken() {
        return this.optionalChildInBucket(3);
    }

    public Optional<ExpressionNode> initializer() {
        return this.optionalChildInBucket(4);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "finalKeyword", "typedBindingPattern", "equalsToken", "initializer", "semicolonToken"};
    }

    public VariableDeclarationNode modify(NodeList<AnnotationNode> annotations, Token finalKeyword, TypedBindingPatternNode typedBindingPattern, Token equalsToken, ExpressionNode initializer, Token semicolonToken) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), finalKeyword, typedBindingPattern, equalsToken, initializer, semicolonToken)) {
            return this;
        }
        return NodeFactory.createVariableDeclarationNode(annotations, finalKeyword, typedBindingPattern, equalsToken, initializer, semicolonToken);
    }

    public VariableDeclarationNodeModifier modify() {
        return new VariableDeclarationNodeModifier(this);
    }

    public static class VariableDeclarationNodeModifier {
        private final VariableDeclarationNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token finalKeyword;
        private TypedBindingPatternNode typedBindingPattern;
        private Token equalsToken;
        private ExpressionNode initializer;
        private Token semicolonToken;

        public VariableDeclarationNodeModifier(VariableDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.finalKeyword = oldNode.finalKeyword().orElse(null);
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.equalsToken = oldNode.equalsToken().orElse(null);
            this.initializer = oldNode.initializer().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public VariableDeclarationNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public VariableDeclarationNodeModifier withFinalKeyword(Token finalKeyword) {
            this.finalKeyword = finalKeyword;
            return this;
        }

        public VariableDeclarationNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public VariableDeclarationNodeModifier withEqualsToken(Token equalsToken) {
            this.equalsToken = equalsToken;
            return this;
        }

        public VariableDeclarationNodeModifier withInitializer(ExpressionNode initializer) {
            this.initializer = initializer;
            return this;
        }

        public VariableDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public VariableDeclarationNode apply() {
            return this.oldNode.modify(this.annotations, this.finalKeyword, this.typedBindingPattern, this.equalsToken, this.initializer, this.semicolonToken);
        }
    }
}

