/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class WaitFieldsListNode
extends NonTerminalNode {
    public WaitFieldsListNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> waitFields() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBrace", "waitFields", "closeBrace"};
    }

    public WaitFieldsListNode modify(Token openBrace, SeparatedNodeList<Node> waitFields, Token closeBrace) {
        if (this.checkForReferenceEquality(openBrace, waitFields.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createWaitFieldsListNode(openBrace, waitFields, closeBrace);
    }

    public WaitFieldsListNodeModifier modify() {
        return new WaitFieldsListNodeModifier(this);
    }

    public static class WaitFieldsListNodeModifier {
        private final WaitFieldsListNode oldNode;
        private Token openBrace;
        private SeparatedNodeList<Node> waitFields;
        private Token closeBrace;

        public WaitFieldsListNodeModifier(WaitFieldsListNode oldNode) {
            this.oldNode = oldNode;
            this.openBrace = oldNode.openBrace();
            this.waitFields = oldNode.waitFields();
            this.closeBrace = oldNode.closeBrace();
        }

        public WaitFieldsListNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public WaitFieldsListNodeModifier withWaitFields(SeparatedNodeList<Node> waitFields) {
            Objects.requireNonNull(waitFields, "waitFields must not be null");
            this.waitFields = waitFields;
            return this;
        }

        public WaitFieldsListNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public WaitFieldsListNode apply() {
            return this.oldNode.modify(this.openBrace, this.waitFields, this.closeBrace);
        }
    }
}

