/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class XMLAtomicNamePatternNode
extends NonTerminalNode {
    public XMLAtomicNamePatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token prefix() {
        return (Token)this.childInBucket(0);
    }

    public Token colon() {
        return (Token)this.childInBucket(1);
    }

    public Token name() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"prefix", "colon", "name"};
    }

    public XMLAtomicNamePatternNode modify(Token prefix, Token colon, Token name) {
        if (this.checkForReferenceEquality(prefix, colon, name)) {
            return this;
        }
        return NodeFactory.createXMLAtomicNamePatternNode(prefix, colon, name);
    }

    public XMLAtomicNamePatternNodeModifier modify() {
        return new XMLAtomicNamePatternNodeModifier(this);
    }

    public static class XMLAtomicNamePatternNodeModifier {
        private final XMLAtomicNamePatternNode oldNode;
        private Token prefix;
        private Token colon;
        private Token name;

        public XMLAtomicNamePatternNodeModifier(XMLAtomicNamePatternNode oldNode) {
            this.oldNode = oldNode;
            this.prefix = oldNode.prefix();
            this.colon = oldNode.colon();
            this.name = oldNode.name();
        }

        public XMLAtomicNamePatternNodeModifier withPrefix(Token prefix) {
            Objects.requireNonNull(prefix, "prefix must not be null");
            this.prefix = prefix;
            return this;
        }

        public XMLAtomicNamePatternNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public XMLAtomicNamePatternNodeModifier withName(Token name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLAtomicNamePatternNode apply() {
            return this.oldNode.modify(this.prefix, this.colon, this.name);
        }
    }
}

