/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLAttributeNode;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLEmptyElementNode
extends XMLItemNode {
    public XMLEmptyElementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public XMLNameNode name() {
        return (XMLNameNode)this.childInBucket(1);
    }

    public NodeList<XMLAttributeNode> attributes() {
        return new NodeList<XMLAttributeNode>((NonTerminalNode)this.childInBucket(2));
    }

    public Token slashToken() {
        return (Token)this.childInBucket(3);
    }

    public Token getToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "name", "attributes", "slashToken", "getToken"};
    }

    public XMLEmptyElementNode modify(Token ltToken, XMLNameNode name, NodeList<XMLAttributeNode> attributes, Token slashToken, Token getToken) {
        if (this.checkForReferenceEquality(ltToken, name, attributes.underlyingListNode(), slashToken, getToken)) {
            return this;
        }
        return NodeFactory.createXMLEmptyElementNode(ltToken, name, attributes, slashToken, getToken);
    }

    public XMLEmptyElementNodeModifier modify() {
        return new XMLEmptyElementNodeModifier(this);
    }

    public static class XMLEmptyElementNodeModifier {
        private final XMLEmptyElementNode oldNode;
        private Token ltToken;
        private XMLNameNode name;
        private NodeList<XMLAttributeNode> attributes;
        private Token slashToken;
        private Token getToken;

        public XMLEmptyElementNodeModifier(XMLEmptyElementNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.name = oldNode.name();
            this.attributes = oldNode.attributes();
            this.slashToken = oldNode.slashToken();
            this.getToken = oldNode.getToken();
        }

        public XMLEmptyElementNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public XMLEmptyElementNodeModifier withName(XMLNameNode name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLEmptyElementNodeModifier withAttributes(NodeList<XMLAttributeNode> attributes) {
            Objects.requireNonNull(attributes, "attributes must not be null");
            this.attributes = attributes;
            return this;
        }

        public XMLEmptyElementNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public XMLEmptyElementNodeModifier withGetToken(Token getToken) {
            Objects.requireNonNull(getToken, "getToken must not be null");
            this.getToken = getToken;
            return this;
        }

        public XMLEmptyElementNode apply() {
            return this.oldNode.modify(this.ltToken, this.name, this.attributes, this.slashToken, this.getToken);
        }
    }
}

