/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLElementTagNode;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLEndTagNode
extends XMLElementTagNode {
    public XMLEndTagNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public Token slashToken() {
        return (Token)this.childInBucket(1);
    }

    public XMLNameNode name() {
        return (XMLNameNode)this.childInBucket(2);
    }

    public Token getToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "slashToken", "name", "getToken"};
    }

    public XMLEndTagNode modify(Token ltToken, Token slashToken, XMLNameNode name, Token getToken) {
        if (this.checkForReferenceEquality(ltToken, slashToken, name, getToken)) {
            return this;
        }
        return NodeFactory.createXMLEndTagNode(ltToken, slashToken, name, getToken);
    }

    public XMLEndTagNodeModifier modify() {
        return new XMLEndTagNodeModifier(this);
    }

    public static class XMLEndTagNodeModifier {
        private final XMLEndTagNode oldNode;
        private Token ltToken;
        private Token slashToken;
        private XMLNameNode name;
        private Token getToken;

        public XMLEndTagNodeModifier(XMLEndTagNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.slashToken = oldNode.slashToken();
            this.name = oldNode.name();
            this.getToken = oldNode.getToken();
        }

        public XMLEndTagNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public XMLEndTagNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public XMLEndTagNodeModifier withName(XMLNameNode name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLEndTagNodeModifier withGetToken(Token getToken) {
            Objects.requireNonNull(getToken, "getToken must not be null");
            this.getToken = getToken;
            return this;
        }

        public XMLEndTagNode apply() {
            return this.oldNode.modify(this.ltToken, this.slashToken, this.name, this.getToken);
        }
    }
}

