/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.XMLNavigateExpressionNode;
import java.util.Objects;

public class XMLStepExpressionNode
extends XMLNavigateExpressionNode {
    public XMLStepExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Node xmlStepStart() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "xmlStepStart"};
    }

    public XMLStepExpressionNode modify(ExpressionNode expression, Node xmlStepStart) {
        if (this.checkForReferenceEquality(expression, xmlStepStart)) {
            return this;
        }
        return NodeFactory.createXMLStepExpressionNode(expression, xmlStepStart);
    }

    public XMLStepExpressionNodeModifier modify() {
        return new XMLStepExpressionNodeModifier(this);
    }

    public static class XMLStepExpressionNodeModifier {
        private final XMLStepExpressionNode oldNode;
        private ExpressionNode expression;
        private Node xmlStepStart;

        public XMLStepExpressionNodeModifier(XMLStepExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.xmlStepStart = oldNode.xmlStepStart();
        }

        public XMLStepExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public XMLStepExpressionNodeModifier withXmlStepStart(Node xmlStepStart) {
            Objects.requireNonNull(xmlStepStart, "xmlStepStart must not be null");
            this.xmlStepStart = xmlStepStart;
            return this;
        }

        public XMLStepExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.xmlStepStart);
        }
    }
}

