/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.tools.text.TextDocument;

public class Document {
    private final DocumentContext documentContext;
    private final Module module;

    Document(DocumentContext documentContext, Module module) {
        this.documentContext = documentContext;
        this.module = module;
    }

    public static Document from(DocumentConfig documentConfig, Module module) {
        DocumentContext documentContext = DocumentContext.from(documentConfig);
        return new Document(documentContext, module);
    }

    public DocumentId documentId() {
        return this.documentContext.documentId();
    }

    public String name() {
        return this.documentContext.name();
    }

    public Module module() {
        return this.module;
    }

    public SyntaxTree syntaxTree() {
        return this.documentContext.syntaxTree();
    }

    public TextDocument textDocument() {
        return this.documentContext.textDocument();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private String content;
        private String name;
        private DocumentId documentId;
        private Module oldModule;

        private Modifier(Document oldDocument) {
            this.documentId = oldDocument.documentId();
            this.name = oldDocument.name();
            this.content = oldDocument.syntaxTree().textDocument().toString();
            this.oldModule = oldDocument.module();
        }

        public Modifier withContent(String content) {
            this.content = content;
            return this;
        }

        public Document apply() {
            DocumentConfig documentConfig = DocumentConfig.from(this.documentId, this.content, this.name);
            DocumentContext documentContext = DocumentContext.from(documentConfig);
            Module newModule = this.oldModule.modify().updateDocument(documentContext).apply();
            return newModule.document(this.documentId);
        }
    }
}

