/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ballerina.projects.BaloWriter;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipOutputStream;

public class JBallerinaBaloWriter
extends BaloWriter {
    public JBallerinaBaloWriter(JdkVersion targetPlatform) {
        this.target = targetPlatform.code();
    }

    @Override
    protected Optional<JsonArray> addPlatformLibs(ZipOutputStream baloOutputStream, Package pkg) throws IOException {
        Path sourceRoot = pkg.project().sourceRoot();
        PackageManifest.Platform platform = pkg.manifest().platform(this.target);
        if (platform == null) {
            return Optional.empty();
        }
        JsonArray newPlatformLibs = new JsonArray();
        for (Map<String, Object> dependency : platform.dependencies()) {
            if (!(dependency.get("path") instanceof String)) continue;
            String path = (String)dependency.get("path");
            Path libPath = sourceRoot.resolve(path);
            String fileName = Optional.ofNullable(libPath.getFileName()).map(p -> p.toString()).orElse("annon");
            Path entryPath = Paths.get("platform", new String[0]).resolve(this.target).resolve(fileName);
            this.putZipEntry(baloOutputStream, entryPath, new FileInputStream(libPath.toString()));
            Gson gson = new Gson();
            JsonElement newDependency = gson.toJsonTree(dependency);
            newDependency.getAsJsonObject().addProperty("path", entryPath.toString());
            newPlatformLibs.add(newDependency);
        }
        return Optional.of(newPlatformLibs);
    }
}

