/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Bootstrap;
import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.Diagnostics;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleCompilationState;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.CompilerPhaseRunner;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.BIRPackageSymbolEnter;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.programfile.PackageFileWriter;

class ModuleContext {
    private final ModuleId moduleId;
    private final ModuleDescriptor moduleDescriptor;
    private final Collection<DocumentId> srcDocIds;
    private final boolean isDefaultModule;
    private final Map<DocumentId, DocumentContext> srcDocContextMap;
    private final Collection<DocumentId> testSrcDocIds;
    private final Map<DocumentId, DocumentContext> testDocContextMap;
    private final Project project;
    private final CompilationCache compilationCache;
    private final List<ModuleDescriptor> moduleDescDependencies;
    private Set<ModuleDependency> moduleDependencies;
    private BLangPackage bLangPackage;
    private BPackageSymbol bPackageSymbol;
    private byte[] birBytes = new byte[0];
    private final Bootstrap bootstrap;
    private ModuleCompilationState moduleCompState;
    private Set<ModuleLoadRequest> allModuleLoadRequests;

    ModuleContext(Project project, ModuleId moduleId, ModuleDescriptor moduleDescriptor, boolean isDefaultModule, Map<DocumentId, DocumentContext> srcDocContextMap, Map<DocumentId, DocumentContext> testDocContextMap, List<ModuleDescriptor> moduleDescDependencies) {
        this.project = project;
        this.moduleId = moduleId;
        this.moduleDescriptor = moduleDescriptor;
        this.isDefaultModule = isDefaultModule;
        this.srcDocContextMap = srcDocContextMap;
        this.srcDocIds = Collections.unmodifiableCollection(srcDocContextMap.keySet());
        this.testDocContextMap = testDocContextMap;
        this.testSrcDocIds = Collections.unmodifiableCollection(testDocContextMap.keySet());
        this.moduleDescDependencies = Collections.unmodifiableList(moduleDescDependencies);
        ProjectEnvironment projectEnvironment = project.projectEnvironmentContext();
        this.bootstrap = new Bootstrap(projectEnvironment.getService(PackageResolver.class));
        this.compilationCache = projectEnvironment.getService(CompilationCache.class);
    }

    static ModuleContext from(Project project, ModuleConfig moduleConfig) {
        HashMap<DocumentId, DocumentContext> srcDocContextMap = new HashMap<DocumentId, DocumentContext>();
        for (DocumentConfig sourceDocConfig : moduleConfig.sourceDocs()) {
            srcDocContextMap.put(sourceDocConfig.documentId(), DocumentContext.from(sourceDocConfig));
        }
        HashMap<DocumentId, DocumentContext> testDocContextMap = new HashMap<DocumentId, DocumentContext>();
        for (DocumentConfig testSrcDocConfig : moduleConfig.testSourceDocs()) {
            testDocContextMap.put(testSrcDocConfig.documentId(), DocumentContext.from(testSrcDocConfig));
        }
        return new ModuleContext(project, moduleConfig.moduleId(), moduleConfig.moduleDescriptor(), moduleConfig.isDefaultModule(), srcDocContextMap, testDocContextMap, moduleConfig.dependencies());
    }

    ModuleId moduleId() {
        return this.moduleId;
    }

    ModuleDescriptor descriptor() {
        return this.moduleDescriptor;
    }

    ModuleName moduleName() {
        return this.moduleDescriptor.name();
    }

    Collection<DocumentId> srcDocumentIds() {
        return this.srcDocIds;
    }

    Collection<DocumentId> testSrcDocumentIds() {
        return this.testSrcDocIds;
    }

    DocumentContext documentContext(DocumentId documentId) {
        if (this.srcDocIds.contains(documentId)) {
            return this.srcDocContextMap.get(documentId);
        }
        return this.testDocContextMap.get(documentId);
    }

    Project project() {
        return this.project;
    }

    boolean isDefaultModule() {
        return this.isDefaultModule;
    }

    Collection<ModuleDependency> dependencies() {
        return this.moduleDependencies;
    }

    List<ModuleDescriptor> moduleDescDependencies() {
        return this.moduleDescDependencies;
    }

    Set<ModuleLoadRequest> populateModuleLoadRequests() {
        this.allModuleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
        for (DocumentContext docContext : this.srcDocContextMap.values()) {
            moduleLoadRequests.addAll(docContext.moduleLoadRequests(PackageDependencyScope.DEFAULT));
        }
        this.allModuleLoadRequests.addAll(moduleLoadRequests);
        return moduleLoadRequests;
    }

    Set<ModuleLoadRequest> populateTestSrcModuleLoadRequests() {
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
        for (DocumentContext docContext : this.testDocContextMap.values()) {
            moduleLoadRequests.addAll(docContext.moduleLoadRequests(PackageDependencyScope.TEST_ONLY));
        }
        this.allModuleLoadRequests.addAll(moduleLoadRequests);
        return moduleLoadRequests;
    }

    BLangPackage bLangPackage() {
        return this.getBLangPackageOrThrow();
    }

    ModuleCompilationState compilationState() {
        return this.moduleCompState;
    }

    private BLangPackage getBLangPackageOrThrow() {
        if (this.bLangPackage == null) {
            throw new IllegalStateException("Compile the module first!");
        }
        return this.bLangPackage;
    }

    List<Diagnostic> diagnostics() {
        if (this.bLangPackage != null) {
            return this.bLangPackage.getDiagnostics();
        }
        return Collections.emptyList();
    }

    private void parseTestSources(BLangPackage pkgNode, PackageID pkgId, CompilerContext compilerContext) {
        BLangTestablePackage testablePkg = TreeBuilder.createTestablePackageNode();
        testablePkg.packageID = pkgId;
        testablePkg.flagSet.add(Flag.TESTABLE);
        testablePkg.pos = new BLangDiagnosticLocation(this.moduleName().toString(), 1, 1, 1, 1);
        pkgNode.addTestablePkg(testablePkg);
        for (DocumentContext documentContext : this.testDocContextMap.values()) {
            testablePkg.addCompilationUnit(documentContext.compilationUnit(compilerContext, pkgId));
        }
    }

    ModuleCompilationState currentCompilationState() {
        if (this.moduleCompState != null) {
            return this.moduleCompState;
        }
        this.moduleCompState = this.compilationCache.getBir(this.moduleDescriptor.name()).length == 0 ? ModuleCompilationState.LOADED_FROM_SOURCES : ModuleCompilationState.LOADED_FROM_CACHE;
        return this.moduleCompState;
    }

    void setCompilationState(ModuleCompilationState moduleCompState) {
        this.moduleCompState = moduleCompState;
    }

    void parse() {
        this.currentCompilationState().parse(this);
    }

    void resolveDependencies(PackageResolution.DependencyResolution dependencyResolution) {
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>();
        if (this.project.kind() == ProjectKind.BALR_PROJECT) {
            for (ModuleDescriptor dependencyModDesc : this.moduleDescDependencies) {
                this.addModuleDependency(dependencyModDesc.org(), dependencyModDesc.packageName(), dependencyModDesc.name(), PackageDependencyScope.DEFAULT, moduleDependencies, dependencyResolution);
            }
        } else {
            Set<ModuleLoadRequest> moduleLoadRequests = this.allModuleLoadRequests;
            for (ModuleLoadRequest modLoadRequest : moduleLoadRequests) {
                PackageOrg packageOrg = modLoadRequest.orgName().isEmpty() ? this.descriptor().org() : modLoadRequest.orgName().get();
                this.addModuleDependency(packageOrg, modLoadRequest.packageName(), modLoadRequest.moduleName(), modLoadRequest.scope(), moduleDependencies, dependencyResolution);
            }
        }
        this.moduleDependencies = Collections.unmodifiableSet(moduleDependencies);
    }

    private void addModuleDependency(PackageOrg org, PackageName packageName, ModuleName moduleName, PackageDependencyScope scope, Set<ModuleDependency> moduleDependencies, PackageResolution.DependencyResolution dependencyResolution) {
        Optional<Module> resolvedModuleOptional = dependencyResolution.getModule(org, packageName, moduleName);
        if (resolvedModuleOptional.isEmpty()) {
            return;
        }
        Module resolvedModule = resolvedModuleOptional.get();
        ModuleDependency moduleDependency = new ModuleDependency(new PackageDependency(resolvedModule.packageInstance().packageId(), scope), resolvedModule.moduleId());
        moduleDependencies.add(moduleDependency);
    }

    void compile(CompilerContext compilerContext) {
        this.currentCompilationState().compile(this, compilerContext);
    }

    void generatePlatformSpecificCode(CompilerContext compilerContext, CompilerBackend compilerBackend) {
        this.currentCompilationState().generatePlatformSpecificCode(this, compilerContext, compilerBackend);
    }

    static void parseInternal(ModuleContext moduleContext) {
        for (DocumentContext docContext : moduleContext.srcDocContextMap.values()) {
            docContext.parse();
        }
    }

    static void resolveDependenciesInternal(ModuleContext moduleContext) {
    }

    static void compileInternal(ModuleContext moduleContext, CompilerContext compilerContext) {
        PackageID moduleCompilationId = moduleContext.descriptor().moduleCompilationId();
        String bootstrapLangLibName = System.getProperty("BOOTSTRAP_LANG_LIB");
        if (bootstrapLangLibName != null) {
            moduleContext.bootstrap.loadLangLib(compilerContext, moduleCompilationId);
        }
        PackageCache packageCache = PackageCache.getInstance(compilerContext);
        SymbolEnter symbolEnter = SymbolEnter.getInstance(compilerContext);
        CompilerPhaseRunner compilerPhaseRunner = CompilerPhaseRunner.getInstance(compilerContext);
        BLangPackage pkgNode = (BLangPackage)TreeBuilder.createPackageNode();
        packageCache.put(moduleCompilationId, pkgNode);
        for (DocumentContext documentContext : moduleContext.srcDocContextMap.values()) {
            pkgNode.addCompilationUnit(documentContext.compilationUnit(compilerContext, moduleCompilationId));
        }
        CompilerOptions compilerOptions = CompilerOptions.getInstance(compilerContext);
        if (!Boolean.parseBoolean(compilerOptions.get(CompilerOptionName.SKIP_TESTS)) && !moduleContext.testSrcDocumentIds().isEmpty()) {
            moduleContext.parseTestSources(pkgNode, moduleCompilationId, compilerContext);
        }
        pkgNode.pos = new BLangDiagnosticLocation(moduleContext.moduleName().toString(), 0, 0, 0, 0);
        symbolEnter.definePackage(pkgNode);
        packageCache.putSymbol(pkgNode.packageID, pkgNode.symbol);
        if (bootstrapLangLibName != null) {
            compilerPhaseRunner.performLangLibTypeCheckPhases(pkgNode);
        } else {
            compilerPhaseRunner.performTypeCheckPhases(pkgNode);
        }
        moduleContext.bLangPackage = pkgNode;
    }

    static void generateCodeInternal(ModuleContext moduleContext, CompilerBackend compilerBackend, CompilerContext compilerContext) {
        String bootstrapLangLibName = System.getProperty("BOOTSTRAP_LANG_LIB");
        CompilerPhaseRunner compilerPhaseRunner = CompilerPhaseRunner.getInstance(compilerContext);
        if (bootstrapLangLibName != null) {
            compilerPhaseRunner.performLangLibBirGenPhases(moduleContext.bLangPackage);
        } else {
            compilerPhaseRunner.performBirGenPhases(moduleContext.bLangPackage);
        }
        ModuleContext.cacheBIR(moduleContext);
        if (Diagnostics.hasErrors(moduleContext.diagnostics())) {
            return;
        }
        compilerBackend.performCodeGen(moduleContext, moduleContext.compilationCache);
    }

    private static void cacheBIR(ModuleContext moduleContext) {
        if (Diagnostics.hasErrors(moduleContext.diagnostics())) {
            return;
        }
        ByteArrayOutputStream birContent = new ByteArrayOutputStream();
        try {
            byte[] pkgBirBinaryContent = PackageFileWriter.writePackage(moduleContext.bLangPackage.symbol.birPackageFile);
            birContent.writeBytes(pkgBirBinaryContent);
            moduleContext.compilationCache.cacheBir(moduleContext.moduleName(), birContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert BIR model to a byte array", e);
        }
    }

    static void loadBirBytesInternal(ModuleContext moduleContext) {
        moduleContext.birBytes = moduleContext.compilationCache.getBir(moduleContext.moduleName());
    }

    static void resolveDependenciesFromBALOInternal(ModuleContext moduleContext) {
    }

    static void loadPackageSymbolInternal(ModuleContext moduleContext, CompilerContext compilerContext) {
        PackageCache packageCache = PackageCache.getInstance(compilerContext);
        BIRPackageSymbolEnter birPackageSymbolEnter = BIRPackageSymbolEnter.getInstance(compilerContext);
        PackageID moduleCompilationId = moduleContext.descriptor().moduleCompilationId();
        moduleContext.bPackageSymbol = birPackageSymbolEnter.definePackage(moduleCompilationId, null, moduleContext.birBytes);
        packageCache.putSymbol(moduleCompilationId, moduleContext.bPackageSymbol);
    }

    static void loadPlatformSpecificCodeInternal(ModuleContext moduleContext, CompilerBackend compilerBackend) {
    }
}

