/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.nio.file.Path;
import java.util.Collection;

public class PackageConfig {
    private final PackageId packageId;
    private final PackageManifest packageManifest;
    private final BallerinaToml ballerinaToml;
    private final Path packagePath;
    private final DependencyGraph<PackageDescriptor> packageDescDependencyGraph;
    private final Collection<ModuleConfig> otherModules;

    private PackageConfig(PackageId packageId, Path packagePath, PackageManifest packageManifest, BallerinaToml ballerinaToml, Collection<ModuleConfig> moduleConfigs, DependencyGraph<PackageDescriptor> packageDescDependencyGraph) {
        this.packageId = packageId;
        this.packagePath = packagePath;
        this.packageManifest = packageManifest;
        this.ballerinaToml = ballerinaToml;
        this.otherModules = moduleConfigs;
        this.packageDescDependencyGraph = packageDescDependencyGraph;
    }

    public static PackageConfig from(PackageId packageId, Path packagePath, PackageManifest packageManifest, BallerinaToml ballerinaToml, Collection<ModuleConfig> moduleConfigs) {
        return new PackageConfig(packageId, packagePath, packageManifest, ballerinaToml, moduleConfigs, DependencyGraph.emptyGraph());
    }

    public static PackageConfig from(PackageId packageId, Path packagePath, PackageManifest packageManifest, BallerinaToml ballerinaToml, Collection<ModuleConfig> moduleConfigs, DependencyGraph<PackageDescriptor> packageDescDependencyGraph) {
        return new PackageConfig(packageId, packagePath, packageManifest, ballerinaToml, moduleConfigs, packageDescDependencyGraph);
    }

    public PackageId packageId() {
        return this.packageId;
    }

    public PackageName packageName() {
        return this.packageManifest.name();
    }

    public PackageOrg packageOrg() {
        return this.packageManifest.org();
    }

    public PackageVersion packageVersion() {
        return this.packageManifest.version();
    }

    public PackageManifest packageManifest() {
        return this.packageManifest;
    }

    public BallerinaToml ballerinaToml() {
        return this.ballerinaToml;
    }

    public CompilationOptions compilationOptions() {
        return null;
    }

    public DependencyGraph<PackageDescriptor> packageDescDependencyGraph() {
        return this.packageDescDependencyGraph;
    }

    public Path packagePath() {
        return this.packagePath;
    }

    public Collection<ModuleConfig> otherModules() {
        return this.otherModules;
    }
}

