/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleCompilation;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class PackageContext {
    private final Map<ModuleId, ModuleContext> moduleContextMap;
    private final Collection<ModuleId> moduleIds;
    private final Project project;
    private final PackageId packageId;
    private final PackageManifest packageManifest;
    private final BallerinaToml ballerinaToml;
    private final CompilationOptions compilationOptions;
    private ModuleContext defaultModuleContext;
    private final DependencyGraph<PackageDescriptor> pkgDescDependencyGraph;
    private Set<PackageDependency> packageDependencies;
    private DependencyGraph<ModuleId> moduleDependencyGraph;
    private PackageResolution packageResolution;
    private PackageCompilation packageCompilation;
    private final Map<ModuleId, ModuleCompilation> moduleCompilationMap;

    PackageContext(Project project, PackageId packageId, PackageManifest packageManifest, BallerinaToml ballerinaToml, CompilationOptions compilationOptions, Map<ModuleId, ModuleContext> moduleContextMap, DependencyGraph<PackageDescriptor> pkgDescDependencyGraph) {
        this.project = project;
        this.packageId = packageId;
        this.packageManifest = packageManifest;
        this.ballerinaToml = ballerinaToml;
        this.compilationOptions = compilationOptions;
        this.moduleIds = Collections.unmodifiableCollection(moduleContextMap.keySet());
        this.moduleContextMap = moduleContextMap;
        this.moduleCompilationMap = new HashMap<ModuleId, ModuleCompilation>();
        this.packageDependencies = Collections.emptySet();
        this.pkgDescDependencyGraph = pkgDescDependencyGraph;
    }

    static PackageContext from(Project project, PackageConfig packageConfig, CompilationOptions compilationOptions) {
        HashMap<ModuleId, ModuleContext> moduleContextMap = new HashMap<ModuleId, ModuleContext>();
        for (ModuleConfig moduleConfig : packageConfig.otherModules()) {
            moduleContextMap.put(moduleConfig.moduleId(), ModuleContext.from(project, moduleConfig));
        }
        return new PackageContext(project, packageConfig.packageId(), packageConfig.packageManifest(), packageConfig.ballerinaToml(), compilationOptions, moduleContextMap, packageConfig.packageDescDependencyGraph());
    }

    PackageId packageId() {
        return this.packageId;
    }

    PackageName packageName() {
        return this.packageManifest.name();
    }

    PackageOrg packageOrg() {
        return this.packageManifest.org();
    }

    PackageVersion packageVersion() {
        return this.packageManifest.version();
    }

    PackageDescriptor descriptor() {
        return this.packageManifest.descriptor();
    }

    PackageManifest manifest() {
        return this.packageManifest;
    }

    Optional<BallerinaToml> ballerinaToml() {
        return Optional.ofNullable(this.ballerinaToml);
    }

    CompilationOptions compilationOptions() {
        return this.compilationOptions;
    }

    Collection<ModuleId> moduleIds() {
        return this.moduleIds;
    }

    ModuleContext moduleContext(ModuleId moduleId) {
        return this.moduleContextMap.get(moduleId);
    }

    ModuleContext moduleContext(ModuleName moduleName) {
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            if (!moduleContext.moduleName().equals(moduleName)) continue;
            return moduleContext;
        }
        return null;
    }

    ModuleContext defaultModuleContext() {
        if (this.defaultModuleContext != null) {
            return this.defaultModuleContext;
        }
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            if (!moduleContext.isDefaultModule()) continue;
            this.defaultModuleContext = moduleContext;
            return this.defaultModuleContext;
        }
        throw new IllegalStateException("Default module not found. This is a bug in the Project API");
    }

    DependencyGraph<ModuleId> moduleDependencyGraph() {
        return this.moduleDependencyGraph;
    }

    ModuleCompilation getModuleCompilation(ModuleContext moduleContext) {
        return this.moduleCompilationMap.computeIfAbsent(moduleContext.moduleId(), moduleId -> new ModuleCompilation(this, moduleContext));
    }

    PackageCompilation getPackageCompilation() {
        if (this.packageCompilation == null) {
            this.packageCompilation = PackageCompilation.from(this);
        }
        return this.packageCompilation;
    }

    PackageResolution getResolution() {
        if (this.packageResolution == null) {
            this.packageResolution = PackageResolution.from(this);
        }
        return this.packageResolution;
    }

    Collection<PackageDependency> packageDependencies() {
        return this.packageDependencies;
    }

    Project project() {
        return this.project;
    }

    DependencyGraph<PackageDescriptor> dependencyGraph() {
        return this.pkgDescDependencyGraph;
    }

    void resolveDependencies(PackageResolution.DependencyResolution dependencyResolution) {
        DependencyGraph.DependencyGraphBuilder<ModuleId> moduleDepGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        HashSet<PackageDependency> packageDependencies = new HashSet<PackageDependency>();
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            moduleDepGraphBuilder.add(moduleContext.moduleId());
            this.resolveModuleDependencies(moduleContext, dependencyResolution, moduleDepGraphBuilder, packageDependencies);
        }
        this.packageDependencies = packageDependencies;
        this.moduleDependencyGraph = moduleDepGraphBuilder.build();
    }

    private void resolveModuleDependencies(ModuleContext moduleContext, PackageResolution.DependencyResolution dependencyResolution, DependencyGraph.DependencyGraphBuilder<ModuleId> moduleDepGraphBuilder, Set<PackageDependency> packageDependencies) {
        moduleContext.resolveDependencies(dependencyResolution);
        for (ModuleDependency moduleDependency : moduleContext.dependencies()) {
            if (moduleDependency.packageDependency().packageId() == this.packageId()) {
                moduleDepGraphBuilder.addDependency(moduleContext.moduleId(), moduleDependency.moduleId());
                continue;
            }
            packageDependencies.add(moduleDependency.packageDependency());
        }
    }
}

