/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PackageManifest {
    private final PackageDescriptor packageDesc;
    private final List<Dependency> dependencies;
    private final Map<String, Platform> platforms;
    private final Map<String, Object> otherEntries;

    private PackageManifest(PackageDescriptor packageDesc, List<Dependency> dependencies, Map<String, Platform> platforms, Map<String, Object> otherEntries) {
        this.packageDesc = packageDesc;
        this.dependencies = Collections.unmodifiableList(dependencies);
        this.platforms = Collections.unmodifiableMap(platforms);
        this.otherEntries = Collections.unmodifiableMap(otherEntries);
    }

    public static PackageManifest from(PackageDescriptor packageDesc) {
        return new PackageManifest(packageDesc, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
    }

    public static PackageManifest from(PackageDescriptor packageDesc, List<Dependency> dependencies, Map<String, Platform> platforms, Map<String, Object> otherEntries) {
        return new PackageManifest(packageDesc, dependencies, platforms, otherEntries);
    }

    public PackageName name() {
        return this.packageDesc.name();
    }

    public PackageOrg org() {
        return this.packageDesc.org();
    }

    public PackageVersion version() {
        return this.packageDesc.version();
    }

    public PackageDescriptor descriptor() {
        return this.packageDesc;
    }

    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    public Platform platform(String platformCode) {
        return this.platforms.get(platformCode);
    }

    public Object getValue(String key) {
        return this.otherEntries.get(key);
    }

    public static class Platform {
        private final List<Map<String, Object>> dependencies;

        public Platform(List<Map<String, Object>> dependencies) {
            this.dependencies = Collections.unmodifiableList(dependencies);
        }

        public List<Map<String, Object>> dependencies() {
            return this.dependencies;
        }
    }

    public static class Dependency {
        private final PackageName packageName;
        private final PackageOrg packageOrg;
        private final PackageVersion semanticVersion;

        public Dependency(PackageName packageName, PackageOrg packageOrg, PackageVersion semanticVersion) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.semanticVersion = semanticVersion;
        }

        public PackageName name() {
            return this.packageName;
        }

        public PackageOrg org() {
            return this.packageOrg;
        }

        public PackageVersion version() {
            return this.semanticVersion;
        }
    }
}

