/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.PackageDependencyGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PackageResolution {
    private final PackageContext rootPackageContext;
    private final PackageCache packageCache;
    private final PackageResolver packageResolver;
    private final DependencyGraph<ResolvedPackageDependency> dependencyGraph;
    private final CompilationOptions compilationOptions;
    private List<ModuleContext> topologicallySortedModuleList;
    private Collection<ResolvedPackageDependency> dependenciesWithTransitives;

    private PackageResolution(PackageContext rootPackageContext) {
        this.rootPackageContext = rootPackageContext;
        this.compilationOptions = rootPackageContext.compilationOptions();
        ProjectEnvironment projectEnvContext = rootPackageContext.project().projectEnvironmentContext();
        this.packageResolver = projectEnvContext.getService(PackageResolver.class);
        this.packageCache = projectEnvContext.getService(PackageCache.class);
        this.dependencyGraph = this.buildDependencyGraph();
        DependencyResolution dependencyResolution = new DependencyResolution(projectEnvContext.getService(PackageCache.class), this.dependencyGraph);
        this.resolveDependencies(dependencyResolution);
    }

    static PackageResolution from(PackageContext rootPackageContext) {
        return new PackageResolution(rootPackageContext);
    }

    public DependencyGraph<ResolvedPackageDependency> dependencyGraph() {
        return this.dependencyGraph;
    }

    public Collection<ResolvedPackageDependency> allDependencies() {
        if (this.dependenciesWithTransitives != null) {
            return this.dependenciesWithTransitives;
        }
        this.dependenciesWithTransitives = this.dependencyGraph.toTopologicallySortedList().stream().filter(resolvedPkg -> resolvedPkg.packageId() != this.rootPackageContext.packageId()).collect(Collectors.toList());
        return this.dependenciesWithTransitives;
    }

    public DependencyGraph<ModuleId> moduleDependencyGraph(PackageId packageId) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    PackageContext packageContext() {
        return this.rootPackageContext;
    }

    List<ModuleContext> topologicallySortedModuleList() {
        return this.topologicallySortedModuleList;
    }

    private DependencyGraph<ResolvedPackageDependency> buildDependencyGraph() {
        return this.getDependencyGraphWithPackageDescriptors();
    }

    private LinkedHashSet<ResolutionRequest> getPackageLoadRequestsOfDirectDependencies() {
        ModuleContext moduleContext;
        LinkedHashSet<ModuleLoadRequest> allModuleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
        for (ModuleId moduleId : this.rootPackageContext.moduleIds()) {
            moduleContext = this.rootPackageContext.moduleContext(moduleId);
            allModuleLoadRequests.addAll(moduleContext.populateModuleLoadRequests());
        }
        if (!this.compilationOptions.skipTests()) {
            for (ModuleId moduleId : this.rootPackageContext.moduleIds()) {
                moduleContext = this.rootPackageContext.moduleContext(moduleId);
                allModuleLoadRequests.addAll(moduleContext.populateTestSrcModuleLoadRequests());
            }
        }
        return this.getPackageLoadRequestsOfDirectDependencies(allModuleLoadRequests);
    }

    private LinkedHashSet<ResolutionRequest> getPackageLoadRequestsOfDirectDependencies(LinkedHashSet<ModuleLoadRequest> moduleLoadRequests) {
        LinkedHashSet<ResolutionRequest> resolutionRequests = new LinkedHashSet<ResolutionRequest>();
        for (ModuleLoadRequest moduleLoadRequest : moduleLoadRequests) {
            Optional<PackageOrg> optionalOrgName = moduleLoadRequest.orgName();
            if (optionalOrgName.isEmpty()) continue;
            PackageOrg requestedPkgOrg = optionalOrgName.get();
            PackageName requestedPkgName = moduleLoadRequest.packageName();
            if (this.rootPackageContext.packageOrg().equals(requestedPkgOrg) && this.rootPackageContext.packageName().equals(requestedPkgName)) continue;
            PackageVersion requestedPkgVersion = this.getVersionFromPackageManifest(requestedPkgOrg, requestedPkgName);
            PackageDescriptor pkdDesc = PackageDescriptor.from(requestedPkgOrg, requestedPkgName, requestedPkgVersion);
            ResolutionRequest resolutionRequest = ResolutionRequest.from(pkdDesc, moduleLoadRequest.scope());
            resolutionRequests.add(resolutionRequest);
        }
        return resolutionRequests;
    }

    private PackageVersion getVersionFromPackageManifest(PackageOrg requestedPkgOrg, PackageName requestedPkgName) {
        for (PackageManifest.Dependency dependency : this.rootPackageContext.manifest().dependencies()) {
            if (!dependency.org().equals(requestedPkgOrg) || !dependency.name().equals(requestedPkgName)) continue;
            return dependency.version();
        }
        return null;
    }

    private DependencyGraph<ResolvedPackageDependency> getDependencyGraphWithPackageDescriptors() {
        PackageDependencyGraphBuilder depGraphBuilder = PackageDependencyGraphBuilder.getInstance();
        if (this.rootPackageContext.project().kind() == ProjectKind.BALR_PROJECT) {
            depGraphBuilder.mergeGraph(this.rootPackageContext.dependencyGraph());
        } else {
            this.createDependencyGraphFromSources(depGraphBuilder);
        }
        return depGraphBuilder.buildPackageDependencyGraph(this.rootPackageContext.descriptor(), this.packageResolver, this.packageCache, this.rootPackageContext.project());
    }

    private void createDependencyGraphFromSources(PackageDependencyGraphBuilder depGraphBuilder) {
        LinkedHashSet<ResolutionRequest> packageLoadRequests = this.getPackageLoadRequestsOfDirectDependencies();
        List<ResolutionResponse> resolutionResponses = this.packageResolver.resolvePackages(new ArrayList<ResolutionRequest>(packageLoadRequests), this.rootPackageContext.project());
        PackageDescriptor rootPkgDesc = this.rootPackageContext.descriptor();
        depGraphBuilder.addNode(rootPkgDesc);
        for (ResolutionResponse resolutionResponse : resolutionResponses) {
            if (resolutionResponse.resolutionStatus() == ResolutionResponse.ResolutionStatus.UNRESOLVED) continue;
            Package directDependency = resolutionResponse.resolvedPackage();
            PackageDescriptor dependencyDescriptor = directDependency.descriptor();
            ResolutionRequest resolutionRequest = resolutionResponse.packageLoadRequest();
            if (resolutionRequest.scope() == PackageDependencyScope.DEFAULT) {
                depGraphBuilder.addDependency(rootPkgDesc, dependencyDescriptor);
                depGraphBuilder.mergeGraph(directDependency.packageContext().dependencyGraph());
                continue;
            }
            if (resolutionRequest.scope() != PackageDependencyScope.TEST_ONLY) continue;
            depGraphBuilder.addTestDependency(rootPkgDesc, dependencyDescriptor);
            depGraphBuilder.mergeTestDependencyGraph(directDependency.packageContext().dependencyGraph());
        }
    }

    private void resolveDependencies(DependencyResolution dependencyResolution) {
        ArrayList<ModuleContext> sortedModuleList = new ArrayList<ModuleContext>();
        List<ResolvedPackageDependency> sortedPackages = this.dependencyGraph.toTopologicallySortedList();
        for (ResolvedPackageDependency pkgDependency : sortedPackages) {
            Package resolvedPackage = pkgDependency.packageInstance();
            resolvedPackage.packageContext().resolveDependencies(dependencyResolution);
            DependencyGraph<ModuleId> moduleDependencyGraph = resolvedPackage.moduleDependencyGraph();
            List<ModuleId> sortedModuleIds = moduleDependencyGraph.toTopologicallySortedList();
            for (ModuleId moduleId : sortedModuleIds) {
                ModuleContext moduleContext = resolvedPackage.module(moduleId).moduleContext();
                sortedModuleList.add(moduleContext);
            }
        }
        this.topologicallySortedModuleList = Collections.unmodifiableList(sortedModuleList);
    }

    static class DependencyResolution {
        private final PackageCache delegate;
        private final DependencyGraph<ResolvedPackageDependency> dependencyGraph;

        private DependencyResolution(PackageCache delegate, DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
            this.delegate = delegate;
            this.dependencyGraph = dependencyGraph;
        }

        public Optional<Package> getPackage(PackageOrg packageOrg, PackageName packageName) {
            List<Package> resolvedPackages = this.delegate.getPackages(packageOrg, packageName);
            for (Package resolvedPackage : resolvedPackages) {
                if (!this.containsPackage(resolvedPackage)) continue;
                return Optional.of(resolvedPackage);
            }
            return Optional.empty();
        }

        public Optional<Module> getModule(PackageOrg packageOrg, PackageName packageName, ModuleName moduleName) {
            Optional<Package> resolvedPkg = this.getPackage(packageOrg, packageName);
            if (resolvedPkg.isEmpty()) {
                return Optional.empty();
            }
            Module resolvedModule = resolvedPkg.get().module(moduleName);
            if (resolvedModule == null) {
                return Optional.empty();
            }
            return Optional.of(resolvedModule);
        }

        private boolean containsPackage(Package pkg) {
            for (ResolvedPackageDependency graphNode : this.dependencyGraph.getNodes()) {
                if (graphNode.packageId() != pkg.packageId()) continue;
                return true;
            }
            return false;
        }
    }
}

