/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ProjectException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticVersion {
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.)?(\\d*)");
    private final int major;
    private final int minor;
    private final int patch;

    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static SemanticVersion from(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch);
    }

    public static SemanticVersion from(String versionString) {
        Matcher matcher = pattern.matcher(versionString);
        if (!matcher.matches()) {
            throw new ProjectException("Specified version: '" + versionString + "' is not semvar compatible");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        String patchStr = matcher.group(3);
        int patch = patchStr != null && !patchStr.isEmpty() ? Integer.parseInt(patchStr) : 0;
        return SemanticVersion.from(major, minor, patch);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public VersionCompatibilityResult compareTo(SemanticVersion other) {
        Objects.requireNonNull(other);
        if (this.major == other.major && this.minor == other.minor && this.patch == other.patch) {
            return VersionCompatibilityResult.EQUAL;
        }
        if (this.major == 0 && other.major == 0) {
            return VersionCompatibilityResult.INCOMPATIBLE;
        }
        if (this.major == 0 || other.major == 0) {
            return VersionCompatibilityResult.INCOMPATIBLE;
        }
        if (this.major == other.major && this.minor == other.minor) {
            return this.patch < other.patch ? VersionCompatibilityResult.LESS_THAN : VersionCompatibilityResult.GREATER_THAN;
        }
        if (this.major == other.major) {
            return this.minor < other.minor ? VersionCompatibilityResult.LESS_THAN : VersionCompatibilityResult.GREATER_THAN;
        }
        return this.major < other.major ? VersionCompatibilityResult.LESS_THAN : VersionCompatibilityResult.GREATER_THAN;
    }

    public static enum VersionCompatibilityResult {
        INCOMPATIBLE,
        EQUAL,
        LESS_THAN,
        GREATER_THAN;

    }
}

