/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ProjectException;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlTransformer;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class TomlDocument {
    private final Path filePath;
    private TextDocument textDocument;
    private SyntaxTree syntaxTree;
    private TomlTableNode tomlAstNode;

    protected TomlDocument(Path filePath) {
        this.filePath = filePath;
    }

    public SyntaxTree syntaxTree() {
        if (this.syntaxTree != null) {
            return this.syntaxTree;
        }
        this.parseToml();
        return this.syntaxTree;
    }

    public TomlTableNode tomlAstNode() {
        if (this.tomlAstNode != null) {
            return this.tomlAstNode;
        }
        this.parseToml();
        return this.tomlAstNode;
    }

    public TextDocument textDocument() {
        if (this.textDocument != null) {
            return this.textDocument;
        }
        try {
            this.textDocument = TextDocuments.from(Files.readString(this.filePath));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read file: " + this.filePath, e);
        }
        return this.textDocument;
    }

    private void parseToml() {
        TextDocument textDocument = this.textDocument();
        try {
            this.syntaxTree = SyntaxTree.from(textDocument, this.getFileName(this.filePath));
            TomlTransformer nodeTransformer = new TomlTransformer();
            this.tomlAstNode = (TomlTableNode)nodeTransformer.transform((DocumentNode)this.syntaxTree.rootNode());
        }
        catch (RuntimeException e) {
            throw new ProjectException("Failed to parse file: " + this.getFileName(this.filePath), e);
        }
    }

    private String getFileName(Path filePath) {
        Path fileNamePath = filePath.getFileName();
        if (fileNamePath != null) {
            return fileNamePath.toString();
        }
        throw new ProjectException("Failed to retrieve the TOML file name from the path: " + filePath);
    }
}

