/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.internal.ProjectFiles;
import java.nio.file.Path;
import java.util.Optional;

public class BuildProject
extends Project {
    public static BuildProject load(ProjectEnvironmentBuilder environmentBuilder, Path projectPath) {
        PackageConfig packageConfig = PackageConfigCreator.createBuildProjectConfig(projectPath);
        BuildProject buildProject = new BuildProject(environmentBuilder, projectPath, new BuildOptionsBuilder().build());
        buildProject.addPackage(packageConfig);
        return buildProject;
    }

    public static BuildProject load(Path projectPath) {
        return BuildProject.load(projectPath, new BuildOptionsBuilder().build());
    }

    public static BuildProject load(Path projectPath, BuildOptions buildOptions) {
        System.setProperty("ballerina.offline.flag", String.valueOf(buildOptions.offlineBuild()));
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        PackageConfig packageConfig = PackageConfigCreator.createBuildProjectConfig(projectPath);
        BuildOptions mergedBuildOptions = ProjectFiles.createBuildOptions(projectPath, buildOptions);
        BuildProject buildProject = new BuildProject(environmentBuilder, projectPath, mergedBuildOptions);
        buildProject.addPackage(packageConfig);
        return buildProject;
    }

    private BuildProject(ProjectEnvironmentBuilder environmentBuilder, Path projectPath, BuildOptions buildOptions) {
        super(ProjectKind.BUILD_PROJECT, projectPath, environmentBuilder, buildOptions);
        this.populateCompilerContext();
    }

    public Optional<Path> modulePath(ModuleId moduleId) {
        if (this.currentPackage().moduleIds().contains(moduleId)) {
            if (this.currentPackage().getDefaultModule().moduleId() == moduleId) {
                return Optional.of(this.sourceRoot);
            }
            return Optional.of(this.sourceRoot.resolve("modules").resolve(this.currentPackage().module(moduleId).moduleName().moduleNamePart()));
        }
        return Optional.empty();
    }

    public Optional<Path> documentPath(DocumentId documentId) {
        for (ModuleId moduleId : this.currentPackage().moduleIds()) {
            Module module = this.currentPackage().module(moduleId);
            Optional<Path> modulePath = this.modulePath(moduleId);
            if (module.documentIds().contains(documentId)) {
                if (!modulePath.isPresent()) continue;
                return Optional.of(modulePath.get().resolve(module.document(documentId).name()));
            }
            if (!module.testDocumentIds().contains(documentId) || !modulePath.isPresent()) continue;
            return Optional.of(modulePath.get().resolve("tests").resolve(module.document(documentId).name().split("tests/")[1]));
        }
        return Optional.empty();
    }
}

