/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.util.Objects;
import java.util.Optional;

public class ModuleLoadRequest {
    private final PackageOrg orgName;
    private final PackageName packageName;
    private final ModuleName moduleName;
    private final PackageVersion version;
    private final PackageDependencyScope scope;

    public ModuleLoadRequest(PackageOrg orgName, PackageName packageName, ModuleName moduleName, PackageVersion version, PackageDependencyScope scope) {
        if (orgName != null && orgName.value().isEmpty()) {
            throw new IllegalArgumentException("The orgName cannot be an empty string. It should be either null or a non-empty string value");
        }
        this.orgName = orgName;
        this.packageName = packageName;
        this.moduleName = moduleName;
        this.version = version;
        this.scope = scope;
    }

    public Optional<PackageOrg> orgName() {
        return Optional.ofNullable(this.orgName);
    }

    public PackageName packageName() {
        return this.packageName;
    }

    public ModuleName moduleName() {
        return this.moduleName;
    }

    public Optional<PackageVersion> version() {
        return Optional.ofNullable(this.version);
    }

    public PackageDependencyScope scope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleLoadRequest that = (ModuleLoadRequest)o;
        return Objects.equals(this.orgName, that.orgName) && this.packageName.equals(that.packageName) && this.moduleName.equals(that.moduleName) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.packageName, this.moduleName, this.version);
    }
}

