/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import com.google.gson.JsonSyntaxException;
import com.moandjiezana.toml.Toml;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.model.BallerinaToml;
import io.ballerina.projects.internal.model.Package;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.toml.exceptions.TomlException;

public class BallerinaTomlProcessor {
    private static Toml toml;

    private BallerinaTomlProcessor() {
    }

    public static BallerinaToml parse(Path tomlPath) {
        try {
            toml = BallerinaTomlProcessor.parseAsToml(tomlPath);
            return BallerinaTomlProcessor.parse(toml);
        }
        catch (TomlException e) {
            throw new ProjectException(e.getMessage(), e);
        }
    }

    public static PackageManifest parseAsPackageManifest(Path tomlPath) {
        try {
            toml = BallerinaTomlProcessor.parseAsToml(tomlPath);
            BallerinaTomlProcessor.parse(toml);
        }
        catch (TomlException e) {
            throw new ProjectException(e.getMessage(), e);
        }
        Map<String, Object> otherEntries = toml.toMap();
        Map packageEntry = (Map)otherEntries.remove("package");
        otherEntries.put("license", packageEntry.get("license"));
        otherEntries.put("authors", packageEntry.get("authors"));
        otherEntries.put("repository", packageEntry.get("repository"));
        otherEntries.put("keywords", packageEntry.get("keywords"));
        PackageOrg packageOrg = PackageOrg.from((String)packageEntry.get("org"));
        PackageName packageName = PackageName.from((String)packageEntry.get("name"));
        PackageVersion packageVersion = PackageVersion.from((String)packageEntry.get("version"));
        PackageDescriptor pkgDesc = PackageDescriptor.from(packageOrg, packageName, packageVersion);
        List dependencyEntries = (List)otherEntries.remove("dependency");
        List<PackageManifest.Dependency> dependencies = BallerinaTomlProcessor.getDependencies(dependencyEntries);
        Map platformEntries = (Map)otherEntries.remove("platform");
        Map<String, PackageManifest.Platform> platforms = BallerinaTomlProcessor.getPlatforms(platformEntries);
        return PackageManifest.from(pkgDesc, dependencies, platforms, otherEntries);
    }

    private static Map<String, PackageManifest.Platform> getPlatforms(Map<String, Object> platformEntries) {
        Map<String, PackageManifest.Platform> platforms;
        if (platformEntries == null || platformEntries.isEmpty()) {
            platforms = Collections.emptyMap();
        } else {
            platforms = new HashMap<String, PackageManifest.Platform>(platformEntries.size());
            for (Map.Entry<String, Object> platformEntry : platformEntries.entrySet()) {
                String platformCode = platformEntry.getKey();
                Map platformValue = (Map)platformEntry.getValue();
                if (platformValue == null) continue;
                List platformDependencies = (List)platformValue.get("dependency");
                PackageManifest.Platform platform = new PackageManifest.Platform(platformDependencies);
                platforms.put(platformCode, platform);
            }
        }
        return platforms;
    }

    private static List<PackageManifest.Dependency> getDependencies(List<Map<String, Object>> dependencyEntries) {
        List<PackageManifest.Dependency> dependencies;
        if (dependencyEntries == null || dependencyEntries.isEmpty()) {
            dependencies = Collections.emptyList();
        } else {
            dependencies = new ArrayList<PackageManifest.Dependency>(dependencyEntries.size());
            for (Map<String, Object> dependencyEntry : dependencyEntries) {
                PackageName depName = PackageName.from((String)dependencyEntry.get("name"));
                PackageOrg depOrg = PackageOrg.from((String)dependencyEntry.get("org"));
                PackageVersion depVersion = PackageVersion.from((String)dependencyEntry.get("version"));
                dependencies.add(new PackageManifest.Dependency(depName, depOrg, depVersion));
            }
        }
        return dependencies;
    }

    private static Toml parseAsToml(Path tomlPath) {
        Toml toml;
        File tomlFile = tomlPath.toFile();
        FileInputStream inputStream = new FileInputStream(tomlFile);
        try {
            Toml toml2 = new Toml().read(inputStream);
            if (toml2.isEmpty()) {
                throw new ProjectException("invalid Ballerina.toml file: organization, name and the version of the package is missing. example: \n[package]\norg=\"my_org\"\nname=\"my_package\"\nversion=\"1.0.0\"\n");
            }
            if (null == toml2.getTable("package")) {
                throw new ProjectException("invalid Ballerina.toml file: cannot find [package]");
            }
            toml = toml2;
        }
        catch (Throwable toml2) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {
                    toml2.addSuppressed(throwable);
                }
                throw toml2;
            }
            catch (JsonSyntaxException | IllegalStateException ise) {
                String tomlErrMsg = BallerinaTomlProcessor.lowerCaseFirstLetter(ise.getMessage().replace("java.lang.IllegalStateException: ", "").toLowerCase(Locale.getDefault()));
                throw new ProjectException("invalid Ballerina.toml file: " + tomlErrMsg);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read the file: " + tomlPath);
            }
        }
        ((InputStream)inputStream).close();
        return toml;
    }

    private static BallerinaToml parse(Toml toml) throws TomlException {
        try {
            BallerinaToml ballerinaToml = toml.to(BallerinaToml.class);
            Package pkg = ballerinaToml.getPackage();
            pkg.setOrg(toml.getString("package.org"));
            pkg.setName(toml.getString("package.name"));
            pkg.setVersion(toml.getString("package.version"));
            pkg.setLicense(toml.getList("package.license"));
            pkg.setAuthors(toml.getList("package.authors"));
            pkg.setRepository(toml.getString("package.repository"));
            pkg.setKeywords(toml.getList("package.keywords"));
            pkg.setExported(toml.getList("package.exported"));
            ballerinaToml.setBuildOptions(BallerinaTomlProcessor.setBuildOptions(toml));
            BallerinaTomlProcessor.validateBallerinaTomlPackage(ballerinaToml);
            BallerinaTomlProcessor.validateManifestDependencies(ballerinaToml);
            return ballerinaToml;
        }
        catch (JsonSyntaxException | IllegalStateException ise) {
            String tomlErrMsg = BallerinaTomlProcessor.lowerCaseFirstLetter(ise.getMessage().replace("java.lang.IllegalStateException: ", "").toLowerCase(Locale.getDefault()));
            throw new TomlException("invalid Ballerina.toml file: " + tomlErrMsg);
        }
    }

    private static BuildOptions setBuildOptions(Toml toml) {
        Toml table = toml.getTable("build-options");
        if (table == null || table.isEmpty()) {
            return null;
        }
        BuildOptionsBuilder buildOptionsBuilder = new BuildOptionsBuilder();
        boolean skipTests = table.getBoolean(CompilerOptionName.SKIP_TESTS.toString(), false);
        boolean offline = table.getBoolean(CompilerOptionName.OFFLINE.toString(), false);
        boolean observabilityIncluded = table.getBoolean(CompilerOptionName.OBSERVABILITY_INCLUDED.toString(), false);
        boolean testReport = table.getBoolean(BuildOptions.OptionName.TEST_REPORT.toString(), false);
        boolean codeCoverage = table.getBoolean(BuildOptions.OptionName.CODE_COVERAGE.toString(), false);
        return buildOptionsBuilder.skipTests(skipTests).offline(offline).observabilityIncluded(observabilityIncluded).testReport(testReport).codeCoverage(codeCoverage).build();
    }

    public static void validateBallerinaTomlPackage(BallerinaToml ballerinaToml) throws TomlException {
        String org = ballerinaToml.getPackage().getOrg();
        if (null == org || "".equals(org)) {
            throw new TomlException("invalid Ballerina.toml file: cannot find 'org' under [package]");
        }
        boolean isValidOrg = ProjectUtils.validateOrgName(org);
        if (!isValidOrg) {
            throw new TomlException("invalid Ballerina.toml file: Invalid 'org' under [package]: '" + org + "' :\n'org' can only contain alphanumerics, underscores and periods and the maximum length is 256 characters");
        }
        String pkg = ballerinaToml.getPackage().getName();
        if (null == pkg || "".equals(pkg)) {
            throw new TomlException("invalid Ballerina.toml file: cannot find 'name' under [package]");
        }
        boolean isValidPkg = ProjectUtils.validatePkgName(pkg);
        if (!isValidPkg) {
            throw new TomlException("invalid Ballerina.toml file: Invalid 'name' under [package]: '" + pkg + "' :\n'name' can only contain alphanumerics, underscores and the maximum length is 256 characters");
        }
        if (null == ballerinaToml.getPackage().getVersion() || "".equals(ballerinaToml.getPackage().getVersion())) {
            throw new TomlException("invalid Ballerina.toml file: cannot find 'version' under [package]");
        }
        Pattern semVerPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher semverMatcher = semVerPattern.matcher(ballerinaToml.getPackage().getVersion());
        if (!semverMatcher.matches()) {
            throw new TomlException("invalid Ballerina.toml file: 'version' under [package] is not semver");
        }
    }

    private static void validateManifestDependencies(BallerinaToml ballerinaToml) throws TomlException {
        ballerinaToml.setDependencies(BallerinaTomlProcessor.getDependenciesAsObjectMap(ballerinaToml.getDependencies()));
        for (Map.Entry<String, Object> dependency : ballerinaToml.getDependencies().entrySet()) {
            if (dependency.getValue() instanceof String || dependency.getValue() instanceof Map) continue;
            throw new TomlException("invalid Ballerina.toml file: invalid metadata found for dependency [" + dependency.getKey() + "]");
        }
    }

    private static Map<String, Object> getDependenciesAsObjectMap(Map<String, Object> dependencies) {
        return dependencies.entrySet().stream().collect(Collectors.toMap(d -> ((String)d.getKey()).replaceAll("^\"|\"$", ""), Map.Entry::getValue));
    }

    private static String lowerCaseFirstLetter(String content) {
        return content.substring(0, 1).toLowerCase(Locale.getDefault()) + content.substring(1);
    }
}

