/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.internal.BaloFiles;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.internal.ProjectFiles;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PackageConfigCreator {
    public static PackageConfig createBuildProjectConfig(Path projectDirPath) {
        ProjectFiles.validateBuildProjectDirPath(projectDirPath);
        Path balTomlFilePath = projectDirPath.resolve("Ballerina.toml");
        BallerinaToml ballerinaToml = BallerinaToml.from(balTomlFilePath);
        PackageManifest packageManifest = ProjectFiles.createPackageManifest(balTomlFilePath);
        PackageData packageData = ProjectFiles.loadBuildProjectPackageData(projectDirPath);
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, ballerinaToml);
    }

    public static PackageConfig createSingleFileProjectConfig(Path filePath) {
        ProjectFiles.validateSingleFileProjectFilePath(filePath);
        PackageDescriptor packageDesc = PackageDescriptor.from(PackageOrg.from("$anon"), PackageName.from("."), PackageVersion.from("0.0.0"));
        PackageManifest packageManifest = PackageManifest.from(packageDesc);
        PackageData packageData = ProjectFiles.loadSingleFileProjectPackageData(filePath);
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest);
    }

    public static PackageConfig createBalrProjectConfig(Path balrPath) {
        ProjectFiles.validateBalrProjectPath(balrPath);
        PackageManifest packageManifest = BaloFiles.createPackageManifest(balrPath);
        PackageData packageData = BaloFiles.loadPackageData(balrPath, packageManifest);
        BaloFiles.DependencyGraphResult packageDependencyGraph = BaloFiles.createPackageDependencyGraph(balrPath, packageManifest.name().value());
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, null, packageDependencyGraph.packageDependencyGraph(), packageDependencyGraph.moduleDependencies());
    }

    public static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest) {
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, null);
    }

    public static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest, BallerinaToml ballerinaToml) {
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, ballerinaToml, DependencyGraph.emptyGraph(), Collections.emptyMap());
    }

    public static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest, BallerinaToml ballerinaToml, DependencyGraph<PackageDescriptor> packageDependencyGraph, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencyGraph) {
        PackageName packageName = packageManifest.name();
        PackageId packageId = PackageId.create(packageName.value());
        List<ModuleConfig> moduleConfigs = packageData.otherModules().stream().map(moduleData -> PackageConfigCreator.createModuleConfig(packageManifest.descriptor(), moduleData, packageId, moduleDependencyGraph)).collect(Collectors.toList());
        moduleConfigs.add(PackageConfigCreator.createDefaultModuleConfig(packageManifest.descriptor(), packageData.defaultModule(), packageId, moduleDependencyGraph));
        return PackageConfig.from(packageId, packageData.packagePath(), packageManifest, ballerinaToml, moduleConfigs, packageDependencyGraph);
    }

    private static ModuleConfig createDefaultModuleConfig(PackageDescriptor pkgDesc, ModuleData moduleData, PackageId packageId, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph) {
        ModuleName moduleName = ModuleName.from(pkgDesc.name());
        ModuleDescriptor moduleDescriptor = PackageConfigCreator.createModuleDescriptor(pkgDesc, moduleName);
        List<ModuleDescriptor> dependencies = PackageConfigCreator.getModuleDependencies(moduleDepGraph, moduleDescriptor);
        return PackageConfigCreator.createModuleConfig(moduleDescriptor, moduleData, packageId, dependencies);
    }

    private static ModuleDescriptor createModuleDescriptor(PackageDescriptor pkgDesc, ModuleName moduleName) {
        return ModuleDescriptor.from(moduleName, pkgDesc);
    }

    private static ModuleConfig createModuleConfig(PackageDescriptor pkgDesc, ModuleData moduleData, PackageId packageId, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph) {
        Path fileName = moduleData.moduleDirectoryPath().getFileName();
        if (fileName == null) {
            throw new IllegalStateException("This branch cannot be reached");
        }
        ModuleName moduleName = ModuleName.from(pkgDesc.name(), moduleData.moduleName());
        ModuleDescriptor moduleDescriptor = PackageConfigCreator.createModuleDescriptor(pkgDesc, moduleName);
        List<ModuleDescriptor> dependencies = PackageConfigCreator.getModuleDependencies(moduleDepGraph, moduleDescriptor);
        return PackageConfigCreator.createModuleConfig(moduleDescriptor, moduleData, packageId, dependencies);
    }

    private static ModuleConfig createModuleConfig(ModuleDescriptor moduleDescriptor, ModuleData moduleData, PackageId packageId, List<ModuleDescriptor> dependencies) {
        ModuleId moduleId = ModuleId.create(moduleDescriptor.name().toString(), packageId);
        List<DocumentConfig> srcDocs = PackageConfigCreator.getDocumentConfigs(moduleId, moduleData.sourceDocs());
        List<DocumentConfig> testSrcDocs = PackageConfigCreator.getDocumentConfigs(moduleId, moduleData.testSourceDocs());
        return ModuleConfig.from(moduleId, moduleDescriptor, srcDocs, testSrcDocs, dependencies);
    }

    private static List<DocumentConfig> getDocumentConfigs(ModuleId moduleId, List<DocumentData> documentData) {
        return documentData.stream().map(srcDoc -> PackageConfigCreator.createDocumentConfig(srcDoc, moduleId)).collect(Collectors.toList());
    }

    static DocumentConfig createDocumentConfig(DocumentData documentData, ModuleId moduleId) {
        DocumentId documentId = DocumentId.create(documentData.name(), moduleId);
        return DocumentConfig.from(documentId, documentData.content(), documentData.name());
    }

    private static List<ModuleDescriptor> getModuleDependencies(Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph, ModuleDescriptor moduleDescriptor) {
        List<ModuleDescriptor> moduleDependencies = moduleDepGraph.get(moduleDescriptor);
        return Objects.requireNonNullElse(moduleDependencies, Collections.emptyList());
    }
}

