/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.internal.repositories.FileSystemRepository;
import io.ballerina.projects.util.ProjectUtils;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.ConnectionErrorException;
import org.ballerinalang.toml.model.Settings;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;

public class RemotePackageRepository
implements PackageRepository {
    private FileSystemRepository fileSystemRepo;
    private CentralAPIClient client;
    private boolean isOffline;

    private RemotePackageRepository(FileSystemRepository fileSystemRepo, CentralAPIClient client) {
        this.fileSystemRepo = fileSystemRepo;
        this.client = client;
        String offlineFlag = System.getProperty("ballerina.offline.flag");
        this.isOffline = offlineFlag != null && offlineFlag.equals("true");
    }

    public static RemotePackageRepository from(Environment environment, Path cacheDirectory, String repoUrl, Settings settings) {
        if (Files.notExists(cacheDirectory, new LinkOption[0])) {
            throw new ProjectException("cache directory does not exists: " + cacheDirectory);
        }
        FileSystemRepository fileSystemRepository = new FileSystemRepository(environment, cacheDirectory);
        Proxy proxy = ProjectUtils.initializeProxy(settings.getProxy());
        CentralAPIClient client = new CentralAPIClient(repoUrl, proxy);
        return new RemotePackageRepository(fileSystemRepository, client);
    }

    public static RemotePackageRepository from(Environment environment, Path cacheDirectory, Settings settings) {
        String repoUrl = RepoUtils.getRemoteRepoURL();
        if ("".equals(repoUrl)) {
            throw new ProjectException("remote repo url is empty");
        }
        return RemotePackageRepository.from(environment, cacheDirectory, repoUrl, settings);
    }

    @Override
    public Optional<Package> getPackage(ResolutionRequest resolutionRequest) {
        Optional<Package> cachedPackage = this.fileSystemRepo.getPackage(resolutionRequest);
        if (cachedPackage.isPresent()) {
            return cachedPackage;
        }
        String packageName = resolutionRequest.packageName().value();
        String orgName = resolutionRequest.orgName().value();
        String version = resolutionRequest.version().isPresent() ? resolutionRequest.version().get().toString() : null;
        Path packagePathInBaloCache = this.fileSystemRepo.balo.resolve(orgName).resolve(packageName);
        if (!this.isOffline) {
            for (String supportedPlatform : ProgramFileConstants.SUPPORTED_PLATFORMS) {
                try {
                    this.client.pullPackage(orgName, packageName, version, packagePathInBaloCache, supportedPlatform, RepoUtils.getBallerinaVersion(), true);
                }
                catch (CentralClientException centralClientException) {
                    // empty catch block
                }
            }
        }
        return this.fileSystemRepo.getPackage(resolutionRequest);
    }

    @Override
    public List<PackageVersion> getPackageVersions(ResolutionRequest resolutionRequest) {
        String orgName = resolutionRequest.orgName().value();
        String packageName = resolutionRequest.packageName().value();
        HashSet<PackageVersion> packageVersions = new HashSet<PackageVersion>(this.fileSystemRepo.getPackageVersions(resolutionRequest));
        if (this.isOffline) {
            return new ArrayList<PackageVersion>(packageVersions);
        }
        try {
            for (String version : this.client.getPackageVersions(orgName, packageName, JdkVersion.JAVA_11.code())) {
                packageVersions.add(PackageVersion.from(version));
            }
        }
        catch (ConnectionErrorException e) {
            return new ArrayList<PackageVersion>(packageVersions);
        }
        catch (CentralClientException e) {
            throw new ProjectException(e.getMessage());
        }
        return new ArrayList<PackageVersion>(packageVersions);
    }

    @Override
    public Map<String, List<String>> getPackages() {
        return this.fileSystemRepo.getPackages();
    }
}

