/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;

public class ErrorCreator {
    private static final BString ERROR_MESSAGE_FIELD = StringUtils.fromString("message");

    public static BError createError(BString message) {
        return new ErrorValue(message, new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    public static BError createError(BString message, BString details) {
        BMapInitialValueEntry[] initialValues = details != null ? new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, details)} : new MappingInitialValueEntry[]{};
        MapValueImpl detailMap = new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return new ErrorValue(message, detailMap);
    }

    public static BError createError(BString message, Throwable throwable) {
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage()), message, ErrorCreator.createError(StringUtils.fromString(throwable.getMessage())), new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    public static BError createError(Type type, BString message, BError cause, BMap<BString, Object> details) {
        return new ErrorValue(type, message, cause, details);
    }

    public static BError createError(Type type, BString message, BString details) {
        BMapInitialValueEntry[] initialValues = details != null ? new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, details)} : new MappingInitialValueEntry[]{};
        MapValueImpl detailMap = new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return new ErrorValue(type, message, null, detailMap);
    }

    public static BError createError(BString message, BMap<BString, Object> details) {
        return new ErrorValue(message, details);
    }

    public static BError createError(Throwable error) {
        if (error instanceof BError) {
            return (BError)error;
        }
        return ErrorCreator.createError(StringUtils.fromString(error.getMessage()));
    }

    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message) {
        return ErrorCreator.createDistinctError(typeIdName, typeIdPkg, message, new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message, BMap<BString, Object> details) {
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, null, details, typeIdName, typeIdPkg);
    }

    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message, BError cause) {
        MapValueImpl details = new MapValueImpl(PredefinedTypes.TYPE_ERROR_DETAIL);
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, cause, details, typeIdName, typeIdPkg);
    }
}

