/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.AttachedFunctionType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.BalStringUtils;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.AbstractObjectValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.BmpStringValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import io.ballerina.runtime.internal.values.RefValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;

public class StringUtils {
    private static final String STR_CYCLE = "...";
    public static final String TO_STRING = "toString";

    public static BString getStringFromInputStream(InputStream in) {
        String result;
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int data;
            while ((data = bis.read()) != -1) {
                bos.write(data);
            }
            result = bos.toString();
        }
        catch (IOException ioe) {
            throw new BallerinaException("Error occurred when reading input stream", ioe);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return StringUtils.fromString(result);
    }

    public static BString getStringFromInputStream(InputStream inputStream, String charset) {
        StringBuilder textBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(charset));){
            int character;
            while ((character = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)character);
            }
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred when reading input stream with the charset" + charset, e);
        }
        return StringUtils.fromString(textBuilder.toString());
    }

    public static BString getStringAt(BString s, long index) {
        if (index < 0L || index >= (long)s.length()) {
            throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.string", "IndexOutOfRange"), StringUtils.fromString("string index out of range: index: " + index + ", size: " + s.length()));
        }
        return StringUtils.fromString(String.valueOf(Character.toChars(s.getCodePoint((int)index))));
    }

    public static BString fromString(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<Integer> highSurrogates = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            if (highSurrogates == null) {
                highSurrogates = new ArrayList<Integer>();
            }
            highSurrogates.add(i - highSurrogates.size());
        }
        if (highSurrogates == null) {
            return new BmpStringValue(s);
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return new NonBmpStringValue(s, highSurrogatesArr);
    }

    public static BArray fromStringArray(String[] s) {
        BString[] bStringArray = new BString[s.length];
        for (int i = 0; i < s.length; ++i) {
            bStringArray[i] = StringUtils.fromString(s[i]);
        }
        return new ArrayValueImpl(bStringArray);
    }

    public static BArray fromStringSet(Set<String> set) {
        BString[] bStringArray = new BString[set.size()];
        int i = 0;
        for (String s : set) {
            bStringArray[i] = StringUtils.fromString(s);
            ++i;
        }
        return new ArrayValueImpl(bStringArray);
    }

    public static String getStringValue(Object value, BLink parent) {
        if (value == null) {
            return "";
        }
        Type type = TypeChecker.getType(value);
        if (value instanceof BString) {
            return ((BString)value).getValue();
        }
        if (type.getTag() < 7) {
            return String.valueOf(value);
        }
        CycleUtils.Node node = new CycleUtils.Node(value, parent);
        if (node.hasCyclesSoFar()) {
            return STR_CYCLE;
        }
        if (type.getTag() == 15 || type.getTag() == 12) {
            MapValueImpl mapValue = (MapValueImpl)value;
            return mapValue.stringValue(parent);
        }
        if (type.getTag() == 20 || type.getTag() == 32) {
            ArrayValue arrayValue = (ArrayValue)value;
            return arrayValue.stringValue(parent);
        }
        if (type.getTag() == 9) {
            return ((RefValue)value).informalStringValue(parent);
        }
        if (type.getTag() == 35) {
            BObject objectValue = (BObject)value;
            ObjectType objectType = objectValue.getType();
            for (AttachedFunctionType func : objectType.getAttachedFunctions()) {
                if (!func.getName().equals(TO_STRING) || func.getParameterTypes().length != 0 || func.getType().getReturnType().getTag() != 5) continue;
                return objectValue.call(Scheduler.getStrand(), TO_STRING, new Object[0]).toString();
            }
        }
        BValue bValue = (BValue)value;
        return bValue.stringValue(parent);
    }

    public static String getExpressionStringValue(Object value, BLink parent) {
        if (value == null) {
            return "()";
        }
        Type type = TypeChecker.getType(value);
        if (value instanceof BString) {
            return "\"" + ((BString)value).getValue() + "\"";
        }
        if (type.getTag() == 4) {
            DecimalValue decimalValue = (DecimalValue)value;
            return decimalValue.expressionStringValue(parent);
        }
        if (type.getTag() == 3) {
            if (Double.isNaN((Double)value)) {
                return "float:" + value;
            }
            if (Double.isInfinite((Double)value)) {
                return "float:" + value;
            }
        }
        if (type.getTag() < 7) {
            return String.valueOf(value);
        }
        CycleUtils.Node node = new CycleUtils.Node(value, parent);
        if (node.hasCyclesSoFar()) {
            return "...[" + node.getIndex() + "]";
        }
        if (type.getTag() == 15 || type.getTag() == 12) {
            MapValueImpl mapValue = (MapValueImpl)value;
            return mapValue.expressionStringValue(parent);
        }
        if (type.getTag() == 20 || type.getTag() == 32) {
            ArrayValue arrayValue = (ArrayValue)value;
            return arrayValue.expressionStringValue(parent);
        }
        if (type.getTag() == 9) {
            return ((RefValue)value).expressionStringValue(parent);
        }
        if (type.getTag() == 35) {
            AbstractObjectValue objectValue = (AbstractObjectValue)value;
            ObjectType objectType = objectValue.getType();
            for (AttachedFunctionType func : objectType.getAttachedFunctions()) {
                if (!func.getName().equals(TO_STRING) || func.getParameterTypes().length != 0 || func.getType().getReturnType().getTag() != 5) continue;
                return "object " + objectValue.call(Scheduler.getStrand(), TO_STRING, new Object[0]).toString();
            }
        }
        if (type.getTag() == 30) {
            RefValue errorValue = (RefValue)value;
            return errorValue.expressionStringValue(parent);
        }
        RefValue refValue = (RefValue)value;
        return refValue.expressionStringValue(parent);
    }

    public static Object parseExpressionStringValue(String value, BLink parent) {
        String exprValue = value.trim();
        int endIndex = exprValue.length() - 1;
        if (exprValue.equals("()")) {
            return null;
        }
        if (exprValue.startsWith("\"") && exprValue.endsWith("\"")) {
            return StringUtils.fromString(exprValue.substring(1, endIndex));
        }
        if (exprValue.matches("[+-]?[0-9][0-9]*")) {
            return Long.parseLong(exprValue);
        }
        if (exprValue.equals("float:Infinity") || exprValue.equals("float:NaN")) {
            return Double.parseDouble(exprValue.substring(6));
        }
        if (exprValue.matches("[+-]?[0-9]+([.][0-9]+)?([Ee][+-]?[0-9]+)?")) {
            return Double.parseDouble(exprValue);
        }
        if (exprValue.matches("[+-]?[0-9]+(.[0-9]+)?([Ee][+-]?[0-9]+)?[d]")) {
            return new DecimalValue(exprValue.substring(0, endIndex));
        }
        if (exprValue.equals("true") || exprValue.equals("false")) {
            return Boolean.parseBoolean(exprValue);
        }
        if (exprValue.startsWith("[") && exprValue.endsWith("]")) {
            return BalStringUtils.parseArrayExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("{") && exprValue.endsWith("}")) {
            return BalStringUtils.parseMapExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("table key")) {
            return BalStringUtils.parseTableExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("xml")) {
            String xml = exprValue.substring(exprValue.indexOf(96) + 1, exprValue.lastIndexOf(96)).trim();
            return BalStringUtils.parseXmlExpressionStringValue(xml, parent);
        }
        if (exprValue.startsWith(STR_CYCLE)) {
            return BalStringUtils.parseCycleDetectedExpressionStringValue(exprValue, parent);
        }
        if (!exprValue.startsWith("error") && !exprValue.startsWith("object")) {
            return BalStringUtils.parseTupleExpressionStringValue(exprValue, parent);
        }
        return ErrorCreator.createError(StringUtils.fromString("{ballerina/lang.value}FromBalStringError"), StringUtils.fromString("fromBalString supported only for Ballerina expression syntax of anydata value"));
    }

    public static String getJsonString(Object value) {
        if (value == null) {
            return "null";
        }
        Type type = TypeChecker.getType(value);
        if (type.getTag() < 7) {
            return String.valueOf(value);
        }
        if (type.getTag() == 15) {
            MapValueImpl mapValue = (MapValueImpl)value;
            return mapValue.getJSONString();
        }
        if (type.getTag() == 20) {
            ArrayValue arrayValue = (ArrayValue)value;
            return arrayValue.getJSONString();
        }
        RefValue refValue = (RefValue)value;
        return refValue.stringValue(null);
    }
}

