/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.internal.BLock;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BLockStore {
    private Map<String, BLock> globalLockMap = new ConcurrentHashMap<String, BLock>();

    public void addLockToMap(String lockName) {
        this.globalLockMap.put(lockName, new BLock());
    }

    public BLock getLockFromMap(String lockName) {
        return this.globalLockMap.computeIfAbsent(lockName, k -> new BLock());
    }

    public void panicIfInLock(String lockName, Strand strand) {
        for (BLock lock : this.globalLockMap.values()) {
            if (lock.isLockFree() || !lock.lockedBySameContext(strand)) continue;
            throw ErrorCreator.createError(BallerinaErrorReasons.ASYNC_CALL_INSIDE_LOCK);
        }
    }
}

