/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.TypeTags;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.AnydataType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.AttachedFunctionType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.DecimalValueKind;
import io.ballerina.runtime.internal.ErrorUtils;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.XmlFactory;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BFutureType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BParameterizedType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BStreamType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.types.BTypedescType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlType;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.HandleValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.StreamValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TypedescValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeChecker {
    public static Object checkCast(Object sourceVal, Type targetType) {
        if (TypeChecker.checkIsType(sourceVal, targetType)) {
            return sourceVal;
        }
        Type sourceType = TypeChecker.getType(sourceVal);
        if (sourceType.getTag() <= 6 && targetType.getTag() <= 6) {
            return TypeConverter.castValues(targetType, sourceVal);
        }
        if (sourceType.getTag() <= 6 && targetType.getTag() == 21) {
            for (Type memberType : ((BUnionType)targetType).getMemberTypes()) {
                try {
                    return TypeConverter.castValues(memberType, sourceVal);
                }
                catch (Exception exception) {
                }
            }
        }
        throw ErrorUtils.createTypeCastError(sourceVal, targetType);
    }

    public static long anyToInt(Object sourceVal) {
        return TypeConverter.anyToIntCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT));
    }

    public static long anyToSigned32(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32));
    }

    public static long anyToSigned16(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16));
    }

    public static long anyToSigned8(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8));
    }

    public static long anyToUnsigned32(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32));
    }

    public static long anyToUnsigned16(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16));
    }

    public static long anyToUnsigned8(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8));
    }

    public static double anyToFloat(Object sourceVal) {
        return TypeConverter.anyToFloatCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_FLOAT));
    }

    public static boolean anyToBoolean(Object sourceVal) {
        return TypeConverter.anyToBooleanCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_BOOLEAN));
    }

    public static int anyToByte(Object sourceVal) {
        return TypeConverter.anyToByteCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_BYTE));
    }

    public static DecimalValue anyToDecimal(Object sourceVal) {
        return TypeConverter.anyToDecimal(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_DECIMAL));
    }

    public static byte anyToJByte(Object sourceVal) {
        return TypeConverter.anyToJByteCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "byte"));
    }

    public static char anyToJChar(Object sourceVal) {
        return TypeConverter.anyToJCharCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "char"));
    }

    public static short anyToJShort(Object sourceVal) {
        return TypeConverter.anyToJShortCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "short"));
    }

    public static int anyToJInt(Object sourceVal) {
        return TypeConverter.anyToJIntCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "int"));
    }

    public static long anyToJLong(Object sourceVal) {
        return TypeConverter.anyToJLongCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "long"));
    }

    public static float anyToJFloat(Object sourceVal) {
        return TypeConverter.anyToJFloatCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "float"));
    }

    public static double anyToJDouble(Object sourceVal) {
        return TypeConverter.anyToJDoubleCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "double"));
    }

    public static boolean anyToJBoolean(Object sourceVal) {
        return TypeConverter.anyToJBooleanCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "boolean"));
    }

    public static boolean checkIsType(Object sourceVal, Type targetType) {
        return TypeChecker.checkIsType(sourceVal, TypeChecker.getType(sourceVal), targetType);
    }

    public static boolean checkIsType(Object sourceVal, Type sourceType, Type targetType) {
        XmlValue val;
        if (TypeChecker.checkIsType(sourceVal, sourceType, targetType, new ArrayList<TypePair>())) {
            return true;
        }
        if (sourceType.getTag() == 8 && (val = (XmlValue)sourceVal).getNodeType() == XmlNodeType.SEQUENCE) {
            return TypeChecker.checkIsLikeOnValue(sourceVal, sourceType, targetType, new ArrayList<TypeValuePair>(), false);
        }
        if (TypeChecker.isMutable(sourceVal, sourceType)) {
            return false;
        }
        return TypeChecker.checkIsLikeOnValue(sourceVal, sourceType, targetType, new ArrayList<TypeValuePair>(), false);
    }

    public static boolean checkIsLikeType(Object sourceValue, Type targetType) {
        return TypeChecker.checkIsLikeType(sourceValue, targetType, false);
    }

    public static boolean checkIsLikeType(Object sourceValue, Type targetType, boolean allowNumericConversion) {
        return TypeChecker.checkIsLikeType(sourceValue, targetType, new ArrayList<TypeValuePair>(), allowNumericConversion);
    }

    public static boolean isSameType(Type sourceType, Type targetType) {
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        if (sourceType.getTag() == targetType.getTag() && sourceType.getTag() == 20) {
            return TypeChecker.checkArrayEquivalent(sourceType, targetType);
        }
        if (sourceType.getTag() == 15 && targetType.getTag() == 15) {
            return targetType.equals(sourceType);
        }
        if (sourceType.getTag() == 14 && targetType.getTag() == 14) {
            return targetType.equals(sourceType);
        }
        if (sourceType.getTag() == 34 && targetType.getTag() == 34) {
            Set<Object> sourceValueSpace = ((BFiniteType)sourceType).valueSpace;
            Set<Object> targetValueSpace = ((BFiniteType)targetType).valueSpace;
            if (sourceValueSpace.size() != targetValueSpace.size()) {
                return false;
            }
            for (Object sourceVal : sourceValueSpace) {
                if (TypeChecker.containsType(targetValueSpace, TypeChecker.getType(sourceVal))) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() == 34) {
            for (Object value : ((BFiniteType)sourceType).valueSpace) {
                if (TypeChecker.isSameType(TypeChecker.getType(value), targetType)) continue;
                return false;
            }
            return true;
        }
        if (targetType.getTag() == 34) {
            for (Object value : ((BFiniteType)targetType).valueSpace) {
                if (TypeChecker.isSameType(TypeChecker.getType(value), sourceType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Type getType(Object value) {
        if (value == null) {
            return PredefinedTypes.TYPE_NULL;
        }
        if (value instanceof Number) {
            if (value instanceof Long) {
                return PredefinedTypes.TYPE_INT;
            }
            if (value instanceof Double) {
                return PredefinedTypes.TYPE_FLOAT;
            }
            if (value instanceof Integer || value instanceof Byte) {
                return PredefinedTypes.TYPE_BYTE;
            }
        } else {
            if (value instanceof String || value instanceof BString) {
                return PredefinedTypes.TYPE_STRING;
            }
            if (value instanceof Boolean) {
                return PredefinedTypes.TYPE_BOOLEAN;
            }
        }
        return ((BValue)value).getType();
    }

    public static boolean isEqual(Object lhsValue, Object rhsValue) {
        return TypeChecker.isEqual(lhsValue, rhsValue, new ArrayList<ValuePair>());
    }

    public static boolean checkDecimalEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    public static boolean checkDecimalLessThan(DecimalValue lhsValue, DecimalValue rhsValue) {
        return !TypeChecker.checkDecimalEqual(lhsValue, rhsValue) && TypeChecker.checkDecimalGreaterThanOrEqual(rhsValue, lhsValue);
    }

    public static boolean checkDecimalLessThanOrEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.checkDecimalEqual(lhsValue, rhsValue) || TypeChecker.checkDecimalGreaterThan(rhsValue, lhsValue);
    }

    public static boolean checkDecimalGreaterThan(DecimalValue lhsValue, DecimalValue rhsValue) {
        switch (lhsValue.valueKind) {
            case POSITIVE_INFINITY: {
                return TypeChecker.isDecimalRealNumber(rhsValue) || rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY;
            }
            case ZERO: 
            case OTHER: {
                return rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY || TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) > 0;
            }
        }
        return false;
    }

    public static boolean checkDecimalGreaterThanOrEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.checkDecimalGreaterThan(lhsValue, rhsValue) || TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    private static boolean isDecimalRealNumber(DecimalValue decimalValue) {
        return decimalValue.valueKind == DecimalValueKind.ZERO || decimalValue.valueKind == DecimalValueKind.OTHER;
    }

    public static boolean isReferenceEqual(Object lhsValue, Object rhsValue) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        Type lhsType = TypeChecker.getType(lhsValue);
        Type rhsType = TypeChecker.getType(rhsValue);
        if (TypeChecker.isSimpleBasicType(lhsType) && TypeChecker.isSimpleBasicType(rhsType)) {
            return TypeChecker.isEqual(lhsValue, rhsValue);
        }
        if (lhsType.getTag() == 8 && rhsType.getTag() == 8) {
            return TypeChecker.isXMLValueRefEqual((XmlValue)lhsValue, (XmlValue)rhsValue);
        }
        if (TypeChecker.isHandleType(lhsType) && TypeChecker.isHandleType(rhsType)) {
            return TypeChecker.isHandleValueRefEqual(lhsValue, rhsValue);
        }
        return false;
    }

    private static boolean isXMLValueRefEqual(XmlValue lhsValue, XmlValue rhsValue) {
        if (lhsValue.getNodeType() != rhsValue.getNodeType()) {
            return false;
        }
        if (lhsValue.getNodeType() == XmlNodeType.SEQUENCE && rhsValue.getNodeType() == XmlNodeType.SEQUENCE) {
            return TypeChecker.isXMLSequenceRefEqual((XmlSequence)lhsValue, (XmlSequence)rhsValue);
        }
        if (lhsValue.getNodeType() == XmlNodeType.TEXT && rhsValue.getNodeType() == XmlNodeType.TEXT) {
            return ((XmlText)lhsValue).equals(rhsValue);
        }
        return false;
    }

    private static boolean isXMLSequenceRefEqual(XmlSequence lhsValue, XmlSequence rhsValue) {
        Iterator<BXml> lhsIter = lhsValue.getChildrenList().iterator();
        Iterator<BXml> rhsIter = rhsValue.getChildrenList().iterator();
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            BXml r;
            BXml l = lhsIter.next();
            if (l == (r = rhsIter.next()) || TypeChecker.isXMLValueRefEqual((XmlValue)l, (XmlValue)r)) continue;
            return false;
        }
        return lhsIter.hasNext() == rhsIter.hasNext();
    }

    public static TypedescValue getTypedesc(Object value) {
        TypedescValue typedesc;
        Type type = TypeChecker.getType(value);
        if (type == null) {
            return null;
        }
        if (value instanceof MapValue && (typedesc = (TypedescValue)((MapValue)value).getTypedesc()) != null) {
            return typedesc;
        }
        return new TypedescValueImpl(type);
    }

    public static Object getAnnotValue(TypedescValue typedescValue, String annotTag) {
        Type describingType = typedescValue.getDescribingType();
        if (!(describingType instanceof BAnnotatableType)) {
            return null;
        }
        return ((BAnnotatableType)describingType).getAnnotation(StringUtils.fromString(annotTag));
    }

    public static Object getAnnotValue(TypedescValue typedescValue, BString annotTag) {
        Type describingType = typedescValue.getDescribingType();
        if (!(describingType instanceof BAnnotatableType)) {
            return null;
        }
        return ((BAnnotatableType)describingType).getAnnotation(annotTag);
    }

    public static boolean checkIsType(Type sourceType, Type targetType) {
        return TypeChecker.checkIsType(sourceType, targetType, (List<TypePair>)null);
    }

    @Deprecated
    public static boolean checkIsType(Type sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        if (targetType.isReadOnly() && !sourceType.isReadOnly()) {
            return false;
        }
        int sourceTypeTag = sourceType.getTag();
        int targetTypeTag = targetType.getTag();
        if (sourceTypeTag == 22) {
            return TypeChecker.checkIsType(((BIntersectionType)sourceType).getEffectiveType(), targetTypeTag != 22 ? targetType : ((BIntersectionType)targetType).getEffectiveType(), unresolvedTypes);
        }
        if (targetTypeTag == 22) {
            return TypeChecker.checkIsType(sourceType, ((BIntersectionType)targetType).getEffectiveType(), unresolvedTypes);
        }
        if (sourceTypeTag == 52) {
            if (targetTypeTag != 52) {
                return TypeChecker.checkIsType(((BParameterizedType)sourceType).getParamValueType(), targetType, (List<TypePair>)unresolvedTypes);
            }
            return TypeChecker.checkIsType(((BParameterizedType)sourceType).getParamValueType(), ((BParameterizedType)targetType).getParamValueType(), unresolvedTypes);
        }
        switch (targetTypeTag) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: {
                if (sourceTypeTag == 34) {
                    return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
                }
                return sourceTypeTag == targetTypeTag;
            }
            case 1: {
                if (sourceTypeTag == 34) {
                    return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
                }
                return sourceTypeTag == 2 || sourceTypeTag == 1;
            }
            case 17: {
                return TypeChecker.checkIsAnyType(sourceType);
            }
            case 11: {
                return sourceType.isAnydata();
            }
            case 19: {
                return TypeChecker.checkIsServiceType(sourceType);
            }
            case 38: {
                return sourceTypeTag == 38;
            }
            case 39: {
                return TypeChecker.isInherentlyImmutableType(sourceType) || sourceType.isReadOnly();
            }
            case 47: 
            case 48: 
            case 49: {
                return targetTypeTag == sourceTypeTag;
            }
        }
        return TypeChecker.checkIsRecursiveType(sourceType, targetType, (List<TypePair>)(unresolvedTypes == null ? new ArrayList<TypePair>() : unresolvedTypes));
    }

    private static boolean checkIsType(Object sourceVal, Type sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        int sourceTypeTag = sourceType.getTag();
        int targetTypeTag = targetType.getTag();
        if (sourceTypeTag != 12 && sourceTypeTag != 35) {
            return TypeChecker.checkIsType(sourceType, targetType);
        }
        if (targetTypeTag == 22) {
            targetType = ((BIntersectionType)targetType).getEffectiveType();
            targetTypeTag = targetType.getTag();
        }
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        if (targetType.isReadOnly() && !sourceType.isReadOnly()) {
            return false;
        }
        switch (targetTypeTag) {
            case 17: {
                return TypeChecker.checkIsAnyType(sourceType);
            }
            case 11: {
                if (sourceTypeTag == 35) {
                    return false;
                }
                return TypeChecker.checkRecordBelongsToAnydataType((MapValue)sourceVal, (BRecordType)sourceType, unresolvedTypes);
            }
            case 39: {
                return TypeChecker.isInherentlyImmutableType(sourceType) || sourceType.isReadOnly();
            }
            case 15: {
                return TypeChecker.checkIsMapType(sourceVal, sourceType, (BMapType)targetType, unresolvedTypes);
            }
            case 7: {
                return TypeChecker.checkIsMapType(sourceVal, sourceType, new BMapType(targetType.isReadOnly() ? PredefinedTypes.TYPE_READONLY_JSON : PredefinedTypes.TYPE_JSON), unresolvedTypes);
            }
            case 12: {
                return TypeChecker.checkIsRecordType(sourceVal, sourceType, (BRecordType)targetType, unresolvedTypes);
            }
            case 21: {
                for (Type type : ((BUnionType)targetType).getMemberTypes()) {
                    if (!TypeChecker.checkIsType(sourceVal, sourceType, type, unresolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 35: {
                return TypeChecker.checkObjectEquivalency(sourceVal, sourceType, (BObjectType)targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkTypeDescType(Type sourceType, BTypedescType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 13) {
            return false;
        }
        BTypedescType sourceTypedesc = (BTypedescType)sourceType;
        return TypeChecker.checkIsType(sourceTypedesc.getConstraint(), targetType.getConstraint(), unresolvedTypes);
    }

    private static boolean checkIsRecursiveType(Type sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        switch (targetType.getTag()) {
            case 15: {
                return TypeChecker.checkIsMapType(sourceType, (BMapType)targetType, unresolvedTypes);
            }
            case 14: {
                return TypeChecker.checkIsStreamType(sourceType, (BStreamType)targetType, unresolvedTypes);
            }
            case 9: {
                return TypeChecker.checkIsTableType(sourceType, (BTableType)targetType, unresolvedTypes);
            }
            case 7: {
                return TypeChecker.checkIsJSONType(sourceType, unresolvedTypes);
            }
            case 12: {
                return TypeChecker.checkIsRecordType(sourceType, (BRecordType)targetType, unresolvedTypes);
            }
            case 37: {
                return TypeChecker.checkIsFunctionType(sourceType, (BFunctionType)targetType);
            }
            case 20: {
                return TypeChecker.checkIsArrayType(sourceType, (BArrayType)targetType, unresolvedTypes);
            }
            case 32: {
                return TypeChecker.checkIsTupleType(sourceType, (BTupleType)targetType, unresolvedTypes);
            }
            case 21: {
                return TypeChecker.checkIsUnionType(sourceType, (BUnionType)targetType, unresolvedTypes);
            }
            case 35: {
                return TypeChecker.checkObjectEquivalency(sourceType, (BObjectType)targetType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.checkIsFiniteType(sourceType, (BFiniteType)targetType, unresolvedTypes);
            }
            case 33: {
                return TypeChecker.checkIsFutureType(sourceType, (BFutureType)targetType, unresolvedTypes);
            }
            case 30: {
                return TypeChecker.checkIsErrorType(sourceType, (BErrorType)targetType, unresolvedTypes);
            }
            case 13: {
                return TypeChecker.checkTypeDescType(sourceType, (BTypedescType)targetType, unresolvedTypes);
            }
            case 8: {
                return TypeChecker.checkIsXMLType(sourceType, targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean isFiniteTypeMatch(BFiniteType sourceType, Type targetType) {
        for (Object bValue : sourceType.valueSpace) {
            if (TypeChecker.checkIsType(bValue, targetType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnionTypeMatch(BUnionType sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        for (Type type : sourceType.getMemberTypes()) {
            if (TypeChecker.checkIsType(type, targetType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsUnionType(Type sourceType, BUnionType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 21: {
                return TypeChecker.isUnionTypeMatch((BUnionType)sourceType, targetType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
            }
        }
        for (Type type : targetType.getMemberTypes()) {
            if (!TypeChecker.checkIsType(sourceType, type, unresolvedTypes)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIsMapType(Type sourceType, BMapType targetType, List<TypePair> unresolvedTypes) {
        Type targetConstrainedType = targetType.getConstrainedType();
        switch (sourceType.getTag()) {
            case 15: {
                return TypeChecker.checkConstraints(((BMapType)sourceType).getConstrainedType(), targetConstrainedType, unresolvedTypes);
            }
            case 12: {
                BRecordType recType = (BRecordType)sourceType;
                BUnionType wideTypeUnion = new BUnionType(TypeChecker.getWideTypeComponents(recType));
                return TypeChecker.checkConstraints(wideTypeUnion, targetConstrainedType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsMapType(Object sourceVal, Type sourceType, BMapType targetType, List<TypePair> unresolvedTypes) {
        Type targetConstrainedType = targetType.getConstrainedType();
        switch (sourceType.getTag()) {
            case 15: {
                return TypeChecker.checkConstraints(((BMapType)sourceType).getConstrainedType(), targetConstrainedType, unresolvedTypes);
            }
            case 12: {
                return TypeChecker.checkIsMapType((MapValue)sourceVal, (BRecordType)sourceType, unresolvedTypes, targetConstrainedType);
            }
        }
        return false;
    }

    private static boolean checkIsMapType(MapValue sourceVal, BRecordType sourceType, List<TypePair> unresolvedTypes, Type targetConstrainedType) {
        for (Field field : sourceType.getFields().values()) {
            if (!SymbolFlags.isFlagOn(field.getFlags(), 32L)) {
                if (TypeChecker.checkIsType(field.getFieldType(), targetConstrainedType, unresolvedTypes)) continue;
                return false;
            }
            BString name = StringUtils.fromString(field.getFieldName());
            if (SymbolFlags.isFlagOn(field.getFlags(), 4096L) && !sourceVal.containsKey(name) || TypeChecker.checkIsLikeType(sourceVal.get(name), targetConstrainedType)) continue;
            return false;
        }
        if (sourceType.sealed) {
            return true;
        }
        return TypeChecker.checkIsType(sourceType.restFieldType, targetConstrainedType, unresolvedTypes);
    }

    private static boolean checkIsXMLType(Type sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() == 34) {
            return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
        }
        BXmlType target = (BXmlType)targetType;
        if (sourceType.getTag() == 8) {
            Type targetConstraint = target.constraint;
            while (target.constraint.getTag() == 8) {
                target = (BXmlType)target.constraint;
                targetConstraint = target.constraint;
            }
            return TypeChecker.checkIsType(((BXmlType)sourceType).constraint, targetConstraint, unresolvedTypes);
        }
        if (TypeTags.isXMLTypeTag(sourceType.getTag())) {
            return TypeChecker.checkIsType(sourceType, target.constraint, unresolvedTypes);
        }
        return false;
    }

    private static List<Type> getWideTypeComponents(BRecordType recType) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Field f : recType.getFields().values()) {
            types.add(f.getFieldType());
        }
        if (!recType.sealed) {
            types.add(recType.restFieldType);
        }
        return types;
    }

    private static boolean checkIsStreamType(Type sourceType, BStreamType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 14) {
            return false;
        }
        return TypeChecker.checkConstraints(((BStreamType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsTableType(Type sourceType, BTableType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 9) {
            return false;
        }
        BTableType srcTableType = (BTableType)sourceType;
        if (!TypeChecker.checkConstraints(srcTableType.getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes)) {
            return false;
        }
        if (targetType.getKeyType() == null && targetType.getFieldNames() == null) {
            return true;
        }
        if (targetType.getKeyType() != null) {
            if (srcTableType.getKeyType() != null && TypeChecker.checkConstraints(srcTableType.getKeyType(), targetType.getKeyType(), unresolvedTypes)) {
                return true;
            }
            if (srcTableType.getFieldNames() == null) {
                return false;
            }
            ArrayList<Type> fieldTypes = new ArrayList<Type>();
            Arrays.stream(srcTableType.getFieldNames()).forEach(field -> fieldTypes.add(Objects.requireNonNull(TypeChecker.getTableConstraintField((Type)srcTableType.getConstrainedType(), (String)field)).type));
            if (fieldTypes.size() == 1) {
                return TypeChecker.checkConstraints((Type)fieldTypes.get(0), targetType.getKeyType(), unresolvedTypes);
            }
            BTupleType tupleType = new BTupleType(fieldTypes);
            return TypeChecker.checkConstraints(tupleType, targetType.getKeyType(), unresolvedTypes);
        }
        return Arrays.equals(srcTableType.getFieldNames(), targetType.getFieldNames());
    }

    static BField getTableConstraintField(Type constraintType, String fieldName) {
        switch (constraintType.getTag()) {
            case 12: {
                Map<String, Field> fieldList = ((BRecordType)constraintType).getFields();
                return (BField)fieldList.get(fieldName);
            }
            case 21: {
                BUnionType unionType = (BUnionType)constraintType;
                List<Type> memTypes = unionType.getMemberTypes();
                List fields = memTypes.stream().map(type -> TypeChecker.getTableConstraintField(type, fieldName)).filter(Objects::nonNull).collect(Collectors.toList());
                if (fields.size() != memTypes.size()) {
                    return null;
                }
                if (!fields.stream().allMatch(field -> TypeChecker.isSameType(field.type, ((BField)fields.get((int)0)).type))) break;
                return (BField)fields.get(0);
            }
        }
        return null;
    }

    private static boolean checkIsJSONType(Type sourceType, List<TypePair> unresolvedTypes) {
        BJsonType jsonType = (BJsonType)PredefinedTypes.TYPE_JSON;
        TypePair pair = new TypePair(sourceType, jsonType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        switch (sourceType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return true;
            }
            case 20: {
                return TypeChecker.checkIsType(((BArrayType)sourceType).getElementType(), (Type)jsonType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, jsonType);
            }
            case 15: {
                return TypeChecker.checkIsType(((BMapType)sourceType).getConstrainedType(), (Type)jsonType, unresolvedTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)sourceType;
                for (Field field : recordType.getFields().values()) {
                    if (TypeChecker.checkIsJSONType(field.getFieldType(), unresolvedTypes)) continue;
                    return false;
                }
                if (!recordType.sealed) {
                    return TypeChecker.checkIsJSONType(recordType.restFieldType, unresolvedTypes);
                }
                return true;
            }
            case 21: {
                for (Type memberType : ((BUnionType)sourceType).getMemberTypes()) {
                    if (TypeChecker.checkIsJSONType(memberType, unresolvedTypes)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkIsRecordType(Type sourceType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 12: {
                return TypeChecker.checkIsRecordType((BRecordType)sourceType, targetType, unresolvedTypes);
            }
            case 15: {
                return TypeChecker.checkIsRecordType((BMapType)sourceType, targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsRecordType(BRecordType sourceRecordType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        TypePair pair = new TypePair(sourceRecordType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        if (targetType.sealed && !sourceRecordType.sealed) {
            return false;
        }
        if (!sourceRecordType.sealed && !TypeChecker.checkIsType(sourceRecordType.restFieldType, targetType.restFieldType, unresolvedTypes)) {
            return false;
        }
        Map<String, Field> sourceFields = sourceRecordType.getFields();
        Set<String> targetFieldNames = targetType.getFields().keySet();
        for (Field targetField : targetType.getFields().values()) {
            Field sourceField = sourceFields.get(targetField.getFieldName());
            if (sourceField == null) {
                return false;
            }
            if (TypeChecker.hasIncompatibleReadOnlyFlags(targetField, sourceField)) {
                return false;
            }
            if (!SymbolFlags.isFlagOn(targetField.getFlags(), 4096L) && SymbolFlags.isFlagOn(sourceField.getFlags(), 4096L)) {
                return false;
            }
            if (TypeChecker.checkIsType(sourceField.getFieldType(), targetField.getFieldType(), unresolvedTypes)) continue;
            return false;
        }
        if (targetType.sealed) {
            return targetFieldNames.containsAll(sourceFields.keySet());
        }
        for (Field field : sourceFields.values()) {
            if (targetFieldNames.contains(field.getFieldName()) || TypeChecker.checkIsType(field.getFieldType(), targetType.restFieldType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsRecordType(BMapType sourceType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        if (targetType.sealed) {
            return false;
        }
        Type constraintType = sourceType.getConstrainedType();
        for (Field field : targetType.getFields().values()) {
            long flags = field.getFlags();
            if (!SymbolFlags.isFlagOn(flags, 4096L)) {
                return false;
            }
            if (SymbolFlags.isFlagOn(flags, 32L) && !sourceType.isReadOnly()) {
                return false;
            }
            if (TypeChecker.checkIsType(constraintType, field.getFieldType(), unresolvedTypes)) continue;
            return false;
        }
        return TypeChecker.checkIsType(constraintType, targetType.restFieldType, unresolvedTypes);
    }

    private static boolean checkRecordBelongsToAnydataType(MapValue sourceVal, BRecordType recordType, List<TypePair> unresolvedTypes) {
        AnydataType targetType = PredefinedTypes.TYPE_ANYDATA;
        TypePair pair = new TypePair(recordType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        Map<String, Field> fields = recordType.getFields();
        for (Field field : fields.values()) {
            String fieldName = field.getFieldName();
            if (SymbolFlags.isFlagOn(field.getFlags(), 32L)) {
                BString fieldNameBString = StringUtils.fromString(fieldName);
                if (SymbolFlags.isFlagOn(field.getFlags(), 4096L) && !sourceVal.containsKey(fieldNameBString) || TypeChecker.checkIsLikeType(sourceVal.get(fieldNameBString), targetType)) continue;
                return false;
            }
            if (TypeChecker.checkIsType(field.getFieldType(), (Type)targetType, unresolvedTypes)) continue;
            return false;
        }
        if (recordType.sealed) {
            return true;
        }
        return TypeChecker.checkIsType(recordType.restFieldType, (Type)targetType, unresolvedTypes);
    }

    private static boolean checkIsRecordType(Object sourceVal, Type sourceType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 12: {
                return TypeChecker.checkIsRecordType((MapValue)sourceVal, (BRecordType)sourceType, targetType, unresolvedTypes);
            }
            case 15: {
                return TypeChecker.checkIsRecordType((BMapType)sourceType, targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsRecordType(MapValue sourceRecordValue, BRecordType sourceRecordType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        TypePair pair = new TypePair(sourceRecordType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        if (targetType.sealed && !sourceRecordType.sealed) {
            return false;
        }
        if (!sourceRecordType.sealed && !TypeChecker.checkIsType(sourceRecordType.restFieldType, targetType.restFieldType, unresolvedTypes)) {
            return false;
        }
        Map<String, Field> sourceFields = sourceRecordType.getFields();
        Set<String> targetFieldNames = targetType.getFields().keySet();
        for (Field targetField : targetType.getFields().values()) {
            String fieldName = targetField.getFieldName();
            Field sourceField = sourceFields.get(fieldName);
            if (sourceField == null) {
                return false;
            }
            if (TypeChecker.hasIncompatibleReadOnlyFlags(targetField, sourceField)) {
                return false;
            }
            boolean optionalTargetField = SymbolFlags.isFlagOn(targetField.getFlags(), 4096L);
            boolean optionalSourceField = SymbolFlags.isFlagOn(sourceField.getFlags(), 4096L);
            if (SymbolFlags.isFlagOn(sourceField.getFlags(), 32L)) {
                BString fieldNameBString = StringUtils.fromString(fieldName);
                if (!(optionalSourceField && !sourceRecordValue.containsKey(fieldNameBString) ? !optionalTargetField : !TypeChecker.checkIsLikeType(sourceRecordValue.get(fieldNameBString), targetField.getFieldType()))) continue;
                return false;
            }
            if (!optionalTargetField && optionalSourceField) {
                return false;
            }
            if (TypeChecker.checkIsType(sourceField.getFieldType(), targetField.getFieldType(), unresolvedTypes)) continue;
            return false;
        }
        if (targetType.sealed) {
            return targetFieldNames.containsAll(sourceFields.keySet());
        }
        for (Field field : sourceFields.values()) {
            if (targetFieldNames.contains(field.getFieldName()) || !(SymbolFlags.isFlagOn(field.getFlags(), 32L) ? !TypeChecker.checkIsLikeType(sourceRecordValue.get(StringUtils.fromString(field.getFieldName())), targetType.restFieldType) : !TypeChecker.checkIsType(field.getFieldType(), targetType.restFieldType, unresolvedTypes))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasIncompatibleReadOnlyFlags(Field targetField, Field sourceField) {
        return SymbolFlags.isFlagOn(targetField.getFlags(), 32L) && !SymbolFlags.isFlagOn(sourceField.getFlags(), 32L);
    }

    private static boolean checkIsArrayType(BArrayType sourceType, BArrayType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getState()) {
            case OPEN: {
                if (targetType.getState() == ArrayType.ArrayState.OPEN) break;
                return false;
            }
            case CLOSED: {
                if (targetType.getState() != ArrayType.ArrayState.CLOSED || sourceType.getSize() == targetType.getSize()) break;
                return false;
            }
        }
        return TypeChecker.checkIsType(sourceType.getElementType(), targetType.getElementType(), unresolvedTypes);
    }

    private static boolean checkIsArrayType(BTupleType sourceType, BArrayType targetType, List<TypePair> unresolvedTypes) {
        List<Type> tupleTypes = sourceType.getTupleTypes();
        Type sourceRestType = sourceType.getRestType();
        Type targetElementType = targetType.getElementType();
        if (targetType.getState() == ArrayType.ArrayState.OPEN) {
            for (Type sourceElementType : tupleTypes) {
                if (TypeChecker.checkIsType(sourceElementType, targetElementType, unresolvedTypes)) continue;
                return false;
            }
            if (sourceRestType != null) {
                return TypeChecker.checkIsType(sourceRestType, targetElementType, unresolvedTypes);
            }
            return true;
        }
        if (sourceRestType != null) {
            return false;
        }
        if (tupleTypes.size() != targetType.getSize()) {
            return false;
        }
        for (Type sourceElementType : tupleTypes) {
            if (TypeChecker.checkIsType(sourceElementType, targetElementType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsArrayType(Type sourceType, BArrayType targetType, List<TypePair> unresolvedTypes) {
        int sourceTypeTag = sourceType.getTag();
        if (sourceTypeTag == 21) {
            for (Type memberType : ((BUnionType)sourceType).getMemberTypes()) {
                if (TypeChecker.checkIsArrayType(memberType, targetType, unresolvedTypes)) continue;
                return false;
            }
            return true;
        }
        if (sourceTypeTag != 20 && sourceTypeTag != 32) {
            return false;
        }
        if (sourceTypeTag == 20) {
            return TypeChecker.checkIsArrayType((BArrayType)sourceType, targetType, unresolvedTypes);
        }
        return TypeChecker.checkIsArrayType((BTupleType)sourceType, targetType, unresolvedTypes);
    }

    private static boolean checkIsTupleType(BArrayType sourceType, BTupleType targetType, List<TypePair> unresolvedTypes) {
        Type sourceElementType = sourceType.getElementType();
        List<Type> targetTypes = targetType.getTupleTypes();
        Type targetRestType = targetType.getRestType();
        switch (sourceType.getState()) {
            case OPEN: {
                if (targetRestType == null) {
                    return false;
                }
                if (targetTypes.isEmpty()) {
                    return TypeChecker.checkIsType(sourceElementType, targetRestType, unresolvedTypes);
                }
                return false;
            }
            case CLOSED: {
                if (sourceType.getSize() < targetTypes.size()) {
                    return false;
                }
                if (targetTypes.isEmpty()) {
                    if (targetRestType != null) {
                        return TypeChecker.checkIsType(sourceElementType, targetRestType, unresolvedTypes);
                    }
                    return sourceType.getSize() == 0;
                }
                for (Type targetElementType : targetTypes) {
                    if (TypeChecker.checkIsType(sourceElementType, targetElementType, unresolvedTypes)) continue;
                    return false;
                }
                if (sourceType.getSize() == targetTypes.size()) {
                    return true;
                }
                if (targetRestType != null) {
                    return TypeChecker.checkIsType(sourceElementType, targetRestType, unresolvedTypes);
                }
                return false;
            }
        }
        return false;
    }

    private static boolean checkIsTupleType(BTupleType sourceType, BTupleType targetType, List<TypePair> unresolvedTypes) {
        int i;
        List<Type> sourceTypes = sourceType.getTupleTypes();
        Type sourceRestType = sourceType.getRestType();
        List<Type> targetTypes = targetType.getTupleTypes();
        Type targetRestType = targetType.getRestType();
        if (sourceRestType != null && targetRestType == null) {
            return false;
        }
        int sourceTypeSize = sourceTypes.size();
        int targetTypeSize = targetTypes.size();
        if (sourceRestType == null && targetRestType == null && sourceTypeSize != targetTypeSize) {
            return false;
        }
        if (sourceTypeSize < targetTypeSize) {
            return false;
        }
        for (i = 0; i < targetTypeSize; ++i) {
            if (TypeChecker.checkIsType(sourceTypes.get(i), targetTypes.get(i), unresolvedTypes)) continue;
            return false;
        }
        if (sourceTypeSize == targetTypeSize) {
            if (sourceRestType != null) {
                return TypeChecker.checkIsType(sourceRestType, targetRestType, unresolvedTypes);
            }
            return true;
        }
        for (i = targetTypeSize; i < sourceTypeSize; ++i) {
            if (TypeChecker.checkIsType(sourceTypes.get(i), targetRestType, unresolvedTypes)) continue;
            return false;
        }
        if (sourceRestType != null) {
            return TypeChecker.checkIsType(sourceRestType, targetRestType, unresolvedTypes);
        }
        return true;
    }

    private static boolean checkIsTupleType(Type sourceType, BTupleType targetType, List<TypePair> unresolvedTypes) {
        int sourceTypeTag = sourceType.getTag();
        if (sourceTypeTag == 21) {
            for (Type memberType : ((BUnionType)sourceType).getMemberTypes()) {
                if (TypeChecker.checkIsTupleType(memberType, targetType, unresolvedTypes)) continue;
                return false;
            }
            return true;
        }
        if (sourceTypeTag != 20 && sourceTypeTag != 32) {
            return false;
        }
        if (sourceTypeTag == 20) {
            return TypeChecker.checkIsTupleType((BArrayType)sourceType, targetType, unresolvedTypes);
        }
        return TypeChecker.checkIsTupleType((BTupleType)sourceType, targetType, unresolvedTypes);
    }

    private static boolean checkIsAnyType(Type sourceType) {
        switch (sourceType.getTag()) {
            case 30: {
                return false;
            }
            case 21: {
                for (Type memberType : ((BUnionType)sourceType).getMemberTypes()) {
                    if (TypeChecker.checkIsAnyType(memberType)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private static boolean checkIsFiniteType(Type sourceType, BFiniteType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 34) {
            return false;
        }
        BFiniteType sourceFiniteType = (BFiniteType)sourceType;
        if (sourceFiniteType.valueSpace.size() != targetType.valueSpace.size()) {
            return false;
        }
        return targetType.valueSpace.containsAll(sourceFiniteType.valueSpace);
    }

    private static boolean checkIsFutureType(Type sourceType, BFutureType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 33) {
            return false;
        }
        return TypeChecker.checkConstraints(((BFutureType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkObjectEquivalency(Type sourceType, BObjectType targetType, List<TypePair> unresolvedTypes) {
        return TypeChecker.checkObjectEquivalency(null, sourceType, targetType, unresolvedTypes);
    }

    private static boolean checkObjectEquivalency(Object sourceVal, Type sourceType, BObjectType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 35) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BObjectType sourceObjectType = (BObjectType)sourceType;
        if (SymbolFlags.isFlagOn(targetType.flags, 0x20000000L) && !SymbolFlags.isFlagOn(sourceObjectType.flags, 0x20000000L)) {
            return false;
        }
        Map<String, Field> targetFields = targetType.getFields();
        Map<String, Field> sourceFields = sourceObjectType.getFields();
        AttachedFunctionType[] targetFuncs = targetType.getAttachedFunctions();
        AttachedFunctionType[] sourceFuncs = sourceObjectType.getAttachedFunctions();
        if (targetType.getFields().values().stream().anyMatch(field -> SymbolFlags.isFlagOn(field.getFlags(), 1024L)) || Stream.of(targetFuncs).anyMatch(func -> SymbolFlags.isFlagOn(func.getFlags(), 1024L))) {
            return false;
        }
        if (targetFields.size() > sourceFields.size() || targetFuncs.length > sourceFuncs.length) {
            return false;
        }
        String targetTypeModule = Optional.ofNullable(targetType.getPackage()).map(Module::toString).orElse("");
        String sourceTypeModule = Optional.ofNullable(sourceObjectType.getPackage()).map(Module::toString).orElse("");
        if (sourceVal == null ? !TypeChecker.checkObjectSubTypeForFields(targetFields, sourceFields, targetTypeModule, sourceTypeModule, unresolvedTypes) : !TypeChecker.checkObjectSubTypeForFieldsByValue(targetFields, sourceFields, targetTypeModule, sourceTypeModule, (BObject)sourceVal, unresolvedTypes)) {
            return false;
        }
        return TypeChecker.checkObjectSubTypeForMethods(unresolvedTypes, targetFuncs, sourceFuncs, targetTypeModule, sourceTypeModule, sourceObjectType, targetType);
    }

    private static boolean checkObjectSubTypeForFields(Map<String, Field> targetFields, Map<String, Field> sourceFields, String targetTypeModule, String sourceTypeModule, List<TypePair> unresolvedTypes) {
        for (Field lhsField : targetFields.values()) {
            Field rhsField = sourceFields.get(lhsField.getFieldName());
            if (rhsField != null && TypeChecker.isInSameVisibilityRegion(targetTypeModule, sourceTypeModule, lhsField.getFlags(), rhsField.getFlags()) && !TypeChecker.hasIncompatibleReadOnlyFlags(lhsField, rhsField) && TypeChecker.checkIsType(rhsField.getFieldType(), lhsField.getFieldType(), unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkObjectSubTypeForFieldsByValue(Map<String, Field> targetFields, Map<String, Field> sourceFields, String targetTypeModule, String sourceTypeModule, BObject sourceObjVal, List<TypePair> unresolvedTypes) {
        for (Field lhsField : targetFields.values()) {
            Object fieldValue;
            Type fieldValueType;
            String name = lhsField.getFieldName();
            Field rhsField = sourceFields.get(name);
            if (rhsField == null || !TypeChecker.isInSameVisibilityRegion(targetTypeModule, sourceTypeModule, lhsField.getFlags(), rhsField.getFlags()) || TypeChecker.hasIncompatibleReadOnlyFlags(lhsField, rhsField)) {
                return false;
            }
            if (!(SymbolFlags.isFlagOn(rhsField.getFlags(), 4L) ? ((fieldValueType = TypeChecker.getType(fieldValue = sourceObjVal.get(StringUtils.fromString(name)))).isReadOnly() ? !TypeChecker.checkIsLikeType(fieldValue, lhsField.getFieldType()) : !TypeChecker.checkIsType(fieldValueType, lhsField.getFieldType(), unresolvedTypes)) : !TypeChecker.checkIsType(rhsField.getFieldType(), lhsField.getFieldType(), unresolvedTypes))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkObjectSubTypeForMethods(List<TypePair> unresolvedTypes, AttachedFunctionType[] targetFuncs, AttachedFunctionType[] sourceFuncs, String targetTypeModule, String sourceTypeModule, BObjectType sourceType, BObjectType targetType) {
        for (AttachedFunctionType lhsFunc : targetFuncs) {
            AttachedFunctionType rhsFunc = TypeChecker.getMatchingInvokableType(sourceFuncs, lhsFunc, unresolvedTypes);
            if (rhsFunc == null || !TypeChecker.isInSameVisibilityRegion(targetTypeModule, sourceTypeModule, lhsFunc.getFlags(), rhsFunc.getFlags())) {
                return false;
            }
            if (SymbolFlags.isFlagOn(lhsFunc.getFlags(), 32768L) == SymbolFlags.isFlagOn(rhsFunc.getFlags(), 32768L)) continue;
            return false;
        }
        BTypeIdSet targetTypeIdSet = targetType.typeIdSet;
        if (targetTypeIdSet == null) {
            return true;
        }
        BTypeIdSet sourceTypeIdSet = sourceType.typeIdSet;
        if (sourceTypeIdSet == null) {
            return false;
        }
        return sourceTypeIdSet.containsAll(targetTypeIdSet);
    }

    private static boolean isInSameVisibilityRegion(String lhsTypePkg, String rhsTypePkg, long lhsFlags, long rhsFlags) {
        if (SymbolFlags.isFlagOn(lhsFlags, 1024L)) {
            return lhsTypePkg.equals(rhsTypePkg);
        }
        if (SymbolFlags.isFlagOn(lhsFlags, 1L)) {
            return SymbolFlags.isFlagOn(rhsFlags, 1L);
        }
        return !SymbolFlags.isFlagOn(rhsFlags, 1024L) && !SymbolFlags.isFlagOn(rhsFlags, 1L) && lhsTypePkg.equals(rhsTypePkg);
    }

    private static AttachedFunctionType getMatchingInvokableType(AttachedFunctionType[] rhsFuncs, AttachedFunctionType lhsFunc, List<TypePair> unresolvedTypes) {
        return Arrays.stream(rhsFuncs).filter(rhsFunc -> lhsFunc.getName().equals(rhsFunc.getName())).filter(rhsFunc -> TypeChecker.checkFunctionTypeEqualityForObjectType(rhsFunc.getType(), lhsFunc.getType(), unresolvedTypes)).findFirst().orElse(null);
    }

    private static boolean checkFunctionTypeEqualityForObjectType(FunctionType source, FunctionType target, List<TypePair> unresolvedTypes) {
        if (TypeChecker.hasIncompatibleIsolatedFlags(target, source)) {
            return false;
        }
        if (source.getParameterTypes().length != target.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < source.getParameterTypes().length; ++i) {
            if (TypeChecker.checkIsType(target.getParameterTypes()[i], source.getParameterTypes()[i], unresolvedTypes)) continue;
            return false;
        }
        if (source.getReturnType() == null && target.getReturnType() == null) {
            return true;
        }
        if (source.getReturnType() == null || target.getReturnType() == null) {
            return false;
        }
        return TypeChecker.checkIsType(source.getReturnType(), target.getReturnType(), unresolvedTypes);
    }

    private static boolean checkIsFunctionType(Type sourceType, BFunctionType targetType) {
        if (sourceType.getTag() != 37) {
            return false;
        }
        BFunctionType source = (BFunctionType)sourceType;
        if (TypeChecker.hasIncompatibleIsolatedFlags(targetType, source)) {
            return false;
        }
        if (source.paramTypes.length != targetType.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < source.paramTypes.length; ++i) {
            if (TypeChecker.checkIsType(targetType.paramTypes[i], source.paramTypes[i], new ArrayList<TypePair>())) continue;
            return false;
        }
        return TypeChecker.checkIsType(source.retType, targetType.retType, new ArrayList<TypePair>());
    }

    private static boolean hasIncompatibleIsolatedFlags(FunctionType target, FunctionType source) {
        return SymbolFlags.isFlagOn(target.getFlags(), 0x20000000L) && !SymbolFlags.isFlagOn(source.getFlags(), 0x20000000L);
    }

    private static boolean checkIsServiceType(Type sourceType) {
        if (sourceType.getTag() == 19) {
            return true;
        }
        if (sourceType.getTag() == 35) {
            long flags = ((BObjectType)sourceType).flags;
            return (flags & 0x40000L) == 262144L;
        }
        return false;
    }

    public static boolean isInherentlyImmutableType(Type sourceType) {
        if (TypeChecker.isSimpleBasicType(sourceType)) {
            return true;
        }
        switch (sourceType.getTag()) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSelectivelyImmutableType(Type type, Set<Type> unresolvedTypes) {
        if (!unresolvedTypes.add(type)) {
            return true;
        }
        switch (type.getTag()) {
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 47: 
            case 48: 
            case 49: {
                return true;
            }
            case 20: {
                Type elementType = ((BArrayType)type).getElementType();
                return TypeChecker.isInherentlyImmutableType(elementType) || TypeChecker.isSelectivelyImmutableType(elementType, unresolvedTypes);
            }
            case 32: {
                BTupleType tupleType = (BTupleType)type;
                for (Type tupMemType : tupleType.getTupleTypes()) {
                    if (TypeChecker.isInherentlyImmutableType(tupMemType) || TypeChecker.isSelectivelyImmutableType(tupMemType, unresolvedTypes)) continue;
                    return false;
                }
                Type tupRestType = tupleType.getRestType();
                if (tupRestType == null) {
                    return true;
                }
                return TypeChecker.isInherentlyImmutableType(tupRestType) || TypeChecker.isSelectivelyImmutableType(tupRestType, unresolvedTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (Field field : recordType.getFields().values()) {
                    Type fieldType = field.getFieldType();
                    if (TypeChecker.isInherentlyImmutableType(fieldType) || TypeChecker.isSelectivelyImmutableType(fieldType, unresolvedTypes)) continue;
                    return false;
                }
                Type recordRestType = recordType.restFieldType;
                if (recordRestType == null) {
                    return true;
                }
                return TypeChecker.isInherentlyImmutableType(recordRestType) || TypeChecker.isSelectivelyImmutableType(recordRestType, unresolvedTypes);
            }
            case 35: {
                BObjectType objectType = (BObjectType)type;
                if (SymbolFlags.isFlagOn(objectType.flags, 0x10000000L) && !SymbolFlags.isFlagOn(objectType.flags, 32L)) {
                    return false;
                }
                for (Field field : objectType.getFields().values()) {
                    Type fieldType = field.getFieldType();
                    if (TypeChecker.isInherentlyImmutableType(fieldType) || TypeChecker.isSelectivelyImmutableType(fieldType, unresolvedTypes)) continue;
                    return false;
                }
                return true;
            }
            case 15: {
                Type constraintType = ((BMapType)type).getConstrainedType();
                return TypeChecker.isInherentlyImmutableType(constraintType) || TypeChecker.isSelectivelyImmutableType(constraintType, unresolvedTypes);
            }
            case 9: {
                Type tableConstraintType = ((BTableType)type).getConstrainedType();
                return TypeChecker.isInherentlyImmutableType(tableConstraintType) || TypeChecker.isSelectivelyImmutableType(tableConstraintType, unresolvedTypes);
            }
            case 21: {
                boolean readonlyIntersectionExists = false;
                for (Type memberType : ((BUnionType)type).getMemberTypes()) {
                    if (!TypeChecker.isInherentlyImmutableType(memberType) && !TypeChecker.isSelectivelyImmutableType(memberType, unresolvedTypes)) continue;
                    readonlyIntersectionExists = true;
                }
                return readonlyIntersectionExists;
            }
        }
        return false;
    }

    private static boolean checkConstraints(Type sourceConstraint, Type targetConstraint, List<TypePair> unresolvedTypes) {
        if (sourceConstraint == null) {
            sourceConstraint = PredefinedTypes.TYPE_ANY;
        }
        if (targetConstraint == null) {
            targetConstraint = PredefinedTypes.TYPE_ANY;
        }
        return TypeChecker.checkIsType(sourceConstraint, targetConstraint, unresolvedTypes);
    }

    private static boolean isMutable(Object value, Type sourceType) {
        if (value == null || sourceType.getTag() < 7 || TypeTags.isIntegerTypeTag(sourceType.getTag()) || sourceType.getTag() == 34 || TypeTags.isStringTypeTag(sourceType.getTag())) {
            return false;
        }
        return !((RefValue)value).isFrozen();
    }

    private static boolean checkArrayEquivalent(Type actualType, Type expType) {
        if (expType.getTag() == 20 && actualType.getTag() == 20) {
            BArrayType lhrArrayType = (BArrayType)expType;
            BArrayType rhsArrayType = (BArrayType)actualType;
            return TypeChecker.checkIsArrayType(rhsArrayType, lhrArrayType, new ArrayList<TypePair>());
        }
        return expType == actualType;
    }

    private static boolean checkIsLikeType(Object sourceValue, Type targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        Type sourceType = TypeChecker.getType(sourceValue);
        if (TypeChecker.checkIsType(sourceType, targetType, new ArrayList<TypePair>())) {
            return true;
        }
        return TypeChecker.checkIsLikeOnValue(sourceValue, sourceType, targetType, unresolvedValues, allowNumericConversion);
    }

    private static boolean checkIsLikeOnValue(Object sourceValue, Type sourceType, Type targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        int sourceTypeTag = sourceType.getTag();
        int targetTypeTag = targetType.getTag();
        if (sourceTypeTag == 22) {
            return TypeChecker.checkIsLikeOnValue(sourceValue, ((BIntersectionType)sourceType).getEffectiveType(), targetTypeTag != 22 ? targetType : ((BIntersectionType)targetType).getEffectiveType(), unresolvedValues, allowNumericConversion);
        }
        if (targetTypeTag == 22) {
            return TypeChecker.checkIsLikeOnValue(sourceValue, sourceType, ((BIntersectionType)targetType).getEffectiveType(), unresolvedValues, allowNumericConversion);
        }
        if (sourceTypeTag == 52) {
            if (targetTypeTag != 52) {
                return TypeChecker.checkIsLikeOnValue(sourceValue, ((BParameterizedType)sourceType).getParamValueType(), targetType, unresolvedValues, allowNumericConversion);
            }
            return TypeChecker.checkIsLikeOnValue(sourceValue, ((BParameterizedType)sourceType).getParamValueType(), ((BParameterizedType)targetType).getParamValueType(), unresolvedValues, allowNumericConversion);
        }
        switch (targetTypeTag) {
            case 39: {
                return true;
            }
            case 2: {
                if (TypeTags.isIntegerTypeTag(sourceTypeTag)) {
                    return TypeChecker.isByteLiteral((Long)sourceValue);
                }
                return allowNumericConversion && TypeConverter.isConvertibleToByte(sourceValue);
            }
            case 1: {
                return allowNumericConversion && TypeConverter.isConvertibleToInt(sourceValue);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (TypeTags.isIntegerTypeTag(sourceTypeTag) || targetTypeTag == 2) {
                    return TypeConverter.isConvertibleToIntSubType(sourceValue, targetType);
                }
                return allowNumericConversion && TypeConverter.isConvertibleToIntSubType(sourceValue, targetType);
            }
            case 3: 
            case 4: {
                return allowNumericConversion && TypeConverter.isConvertibleToFloatingPointTypes(sourceValue);
            }
            case 46: {
                return TypeConverter.isConvertibleToChar(sourceValue);
            }
            case 12: {
                return TypeChecker.checkIsLikeRecordType(sourceValue, (BRecordType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 7: {
                return TypeChecker.checkIsLikeJSONType(sourceValue, sourceType, (BJsonType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 15: {
                return TypeChecker.checkIsLikeMapType(sourceValue, (BMapType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 14: {
                return TypeChecker.checkIsLikeStreamType(sourceValue, (BStreamType)targetType);
            }
            case 20: {
                return TypeChecker.checkIsLikeArrayType(sourceValue, (BArrayType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 32: {
                return TypeChecker.checkIsLikeTupleType(sourceValue, (BTupleType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 30: {
                return TypeChecker.checkIsLikeErrorType(sourceValue, (BErrorType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 11: {
                return TypeChecker.checkIsLikeAnydataType(sourceValue, sourceType, unresolvedValues, allowNumericConversion);
            }
            case 34: {
                return TypeChecker.checkFiniteTypeAssignable(sourceValue, sourceType, (BFiniteType)targetType);
            }
            case 47: {
                if (sourceTypeTag == 8) {
                    XmlValue xmlSource = (XmlValue)sourceValue;
                    return xmlSource.isSingleton();
                }
                return false;
            }
            case 48: 
            case 49: 
            case 50: {
                if (sourceTypeTag == 8) {
                    return TypeChecker.checkIsLikeNonElementSingleton((XmlValue)sourceValue, targetType);
                }
                return false;
            }
            case 8: {
                if (sourceTypeTag == 8) {
                    return TypeChecker.checkIsLikeXMLSequenceType((XmlValue)sourceValue, targetType);
                }
                return false;
            }
            case 21: {
                if (allowNumericConversion) {
                    ArrayList<Type> compatibleTypesWithNumConversion = new ArrayList<Type>();
                    ArrayList<Type> compatibleTypesWithoutNumConversion = new ArrayList<Type>();
                    for (Type type : ((BUnionType)targetType).getMemberTypes()) {
                        ArrayList<TypeValuePair> tempList = new ArrayList<TypeValuePair>(unresolvedValues.size());
                        tempList.addAll(unresolvedValues);
                        if (TypeChecker.checkIsLikeType(sourceValue, type, tempList, false)) {
                            compatibleTypesWithoutNumConversion.add(type);
                        }
                        if (!TypeChecker.checkIsLikeType(sourceValue, type, unresolvedValues, true)) continue;
                        compatibleTypesWithNumConversion.add(type);
                    }
                    return compatibleTypesWithNumConversion.size() != 0 && compatibleTypesWithNumConversion.size() - compatibleTypesWithoutNumConversion.size() <= 1;
                }
                for (Type type : ((BUnionType)targetType).getMemberTypes()) {
                    if (!TypeChecker.checkIsLikeType(sourceValue, type, unresolvedValues, false)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static XmlNodeType getXmlNodeType(Type type) {
        XmlNodeType nodeType = null;
        switch (type.getTag()) {
            case 47: {
                nodeType = XmlNodeType.ELEMENT;
                break;
            }
            case 49: {
                nodeType = XmlNodeType.COMMENT;
                break;
            }
            case 48: {
                nodeType = XmlNodeType.PI;
                break;
            }
            case 50: {
                nodeType = XmlNodeType.TEXT;
                break;
            }
            default: {
                return null;
            }
        }
        return nodeType;
    }

    private static boolean checkIsLikeNonElementSingleton(XmlValue xmlSource, Type targetType) {
        XmlNodeType nodeType = TypeChecker.getXmlNodeType(targetType);
        if (nodeType == null) {
            return false;
        }
        if (xmlSource.getNodeType() == nodeType) {
            return true;
        }
        if (xmlSource.getNodeType() == XmlNodeType.SEQUENCE) {
            XmlSequence seq = (XmlSequence)xmlSource;
            return seq.size() == 1 && seq.getChildrenList().get(0).getNodeType() == nodeType || nodeType == XmlNodeType.TEXT && seq.isEmpty();
        }
        return false;
    }

    private static boolean checkIsLikeXMLSequenceType(XmlValue xmlSource, Type targetType) {
        if (xmlSource.getNodeType() != XmlNodeType.SEQUENCE) {
            return false;
        }
        HashSet<XmlNodeType> acceptedNodes = new HashSet<XmlNodeType>();
        BXmlType target = (BXmlType)targetType;
        if (target.constraint.getTag() == 21) {
            TypeChecker.getXMLNodeOnUnion((BUnionType)target.constraint, acceptedNodes);
        } else {
            acceptedNodes.add(TypeChecker.getXmlNodeType(((BXmlType)targetType).constraint));
        }
        XmlSequence seq = (XmlSequence)xmlSource;
        for (BXml m : seq.getChildrenList()) {
            if (acceptedNodes.contains((Object)m.getNodeType())) continue;
            return false;
        }
        return true;
    }

    private static void getXMLNodeOnUnion(BUnionType unionType, Set<XmlNodeType> nodeTypes) {
        if (nodeTypes.size() == 4) {
            return;
        }
        for (Type memberType : unionType.getMemberTypes()) {
            if (memberType.getTag() == 21) {
                TypeChecker.getXMLNodeOnUnion((BUnionType)memberType, nodeTypes);
                continue;
            }
            nodeTypes.add(TypeChecker.getXmlNodeType(memberType));
        }
    }

    public static boolean isNumericType(Type type) {
        return type.getTag() < 5;
    }

    private static boolean checkIsLikeAnydataType(Object sourceValue, Type sourceType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        switch (sourceType.getTag()) {
            case 7: 
            case 12: 
            case 15: {
                return TypeChecker.isLikeType(((MapValueImpl)sourceValue).values().toArray(), PredefinedTypes.TYPE_ANYDATA, unresolvedValues, allowNumericConversion);
            }
            case 20: {
                ArrayValue arr = (ArrayValue)sourceValue;
                BArrayType arrayType = (BArrayType)arr.getType();
                switch (arrayType.getElementType().getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return TypeChecker.isLikeType(arr.getValues(), PredefinedTypes.TYPE_ANYDATA, unresolvedValues, allowNumericConversion);
            }
            case 32: {
                return TypeChecker.isLikeType(((ArrayValue)sourceValue).getValues(), PredefinedTypes.TYPE_ANYDATA, unresolvedValues, allowNumericConversion);
            }
            case 11: {
                return true;
            }
            case 21: 
            case 34: {
                return TypeChecker.checkIsLikeType(sourceValue, PredefinedTypes.TYPE_ANYDATA, unresolvedValues, allowNumericConversion);
            }
        }
        return false;
    }

    private static boolean isLikeType(Object[] objects, Type targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        for (Object value : objects) {
            if (TypeChecker.checkIsLikeType(value, targetType, unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeTupleType(Object sourceValue, BTupleType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        int i;
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source = (ArrayValue)sourceValue;
        List<Type> targetTypes = targetType.getTupleTypes();
        int sourceTypeSize = source.size();
        int targetTypeSize = targetTypes.size();
        Type targetRestType = targetType.getRestType();
        if (sourceTypeSize < targetTypeSize) {
            return false;
        }
        if (targetRestType == null && sourceTypeSize > targetTypeSize) {
            return false;
        }
        for (i = 0; i < targetTypeSize; ++i) {
            if (TypeChecker.checkIsLikeType(source.getRefValue(i), targetTypes.get(i), unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        for (i = targetTypeSize; i < sourceTypeSize; ++i) {
            if (TypeChecker.checkIsLikeType(source.getRefValue(i), targetRestType, unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    static boolean isByteLiteral(long longValue) {
        return longValue >= (long)RuntimeConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)RuntimeConstants.BBYTE_MAX_VALUE.intValue();
    }

    static boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)RuntimeConstants.SIGNED32_MIN_VALUE.intValue() && longObject <= (long)RuntimeConstants.SIGNED32_MAX_VALUE.intValue();
    }

    static boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= RuntimeConstants.SIGNED16_MIN_VALUE && longObject.intValue() <= RuntimeConstants.SIGNED16_MAX_VALUE;
    }

    static boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= RuntimeConstants.SIGNED8_MIN_VALUE && longObject.intValue() <= RuntimeConstants.SIGNED8_MAX_VALUE;
    }

    static boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= RuntimeConstants.UNSIGNED32_MAX_VALUE;
    }

    static boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= RuntimeConstants.UNSIGNED16_MAX_VALUE;
    }

    static boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= RuntimeConstants.UNSIGNED8_MAX_VALUE;
    }

    static boolean isCharLiteralValue(Object object) {
        String value;
        if (object instanceof BString) {
            value = ((BString)object).getValue();
        } else if (object instanceof String) {
            value = (String)object;
        } else {
            return false;
        }
        return value.codePoints().count() == 1L;
    }

    private static boolean checkIsLikeArrayType(Object sourceValue, BArrayType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        Type sourceElementType;
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source = (ArrayValue)sourceValue;
        Type targetTypeElementType = targetType.getElementType();
        if (source.getType().getTag() == 20 && TypeUtils.isValueType(sourceElementType = ((BArrayType)source.getType()).getElementType())) {
            boolean isType = TypeChecker.checkIsType(sourceElementType, targetTypeElementType, new ArrayList<TypePair>());
            if (isType || !allowNumericConversion || !TypeChecker.isNumericType(sourceElementType)) {
                return isType;
            }
            if (TypeChecker.isNumericType(targetTypeElementType)) {
                return true;
            }
            if (targetTypeElementType.getTag() != 21) {
                return false;
            }
            ArrayList<Type> targetNumericTypes = new ArrayList<Type>();
            for (Type memType : ((BUnionType)targetTypeElementType).getMemberTypes()) {
                if (!TypeChecker.isNumericType(memType) || targetNumericTypes.contains(memType)) continue;
                targetNumericTypes.add(memType);
            }
            return targetNumericTypes.size() == 1;
        }
        Object[] arrayValues = source.getValues();
        for (int i = 0; i < ((ArrayValue)sourceValue).size(); ++i) {
            if (TypeChecker.checkIsLikeType(arrayValues[i], targetTypeElementType, unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeMapType(Object sourceValue, BMapType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        for (Object mapEntry : ((MapValueImpl)sourceValue).values()) {
            if (TypeChecker.checkIsLikeType(mapEntry, targetType.getConstrainedType(), unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeStreamType(Object sourceValue, BStreamType targetType) {
        if (!(sourceValue instanceof StreamValue)) {
            return false;
        }
        BStreamType streamType = (BStreamType)((StreamValue)sourceValue).getType();
        return streamType.getConstrainedType() == targetType.getConstrainedType();
    }

    private static boolean checkIsLikeJSONType(Object sourceValue, Type sourceType, BJsonType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (sourceType.getTag() == 20) {
            ArrayValue source = (ArrayValue)sourceValue;
            Type elementType = ((BArrayType)source.getType()).getElementType();
            if (TypeUtils.isValueType(elementType)) {
                return TypeChecker.checkIsType(elementType, (Type)targetType, new ArrayList<TypePair>());
            }
            Object[] arrayValues = source.getValues();
            for (int i = 0; i < ((ArrayValue)sourceValue).size(); ++i) {
                if (TypeChecker.checkIsLikeType(arrayValues[i], targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() == 15) {
            for (Object value : ((MapValueImpl)sourceValue).values()) {
                if (TypeChecker.checkIsLikeType(value, targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() == 12) {
            TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
            if (unresolvedValues.contains(typeValuePair)) {
                return true;
            }
            unresolvedValues.add(typeValuePair);
            for (Object object : ((MapValueImpl)sourceValue).values()) {
                if (TypeChecker.checkIsLikeType(object, targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean checkIsLikeRecordType(Object sourceValue, BRecordType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, Type> targetTypeField = new HashMap<String, Type>();
        Type restFieldType = targetType.restFieldType;
        for (Field field : targetType.getFields().values()) {
            targetTypeField.put(field.getFieldName(), field.getFieldType());
        }
        for (Map.Entry entry : targetTypeField.entrySet()) {
            BString fieldName = StringUtils.fromString(entry.getKey().toString());
            if (((MapValueImpl)sourceValue).containsKey(fieldName) || SymbolFlags.isFlagOn(targetType.getFields().get(fieldName.toString()).getFlags(), 4096L)) continue;
            return false;
        }
        for (Object object : ((MapValueImpl)sourceValue).entrySet()) {
            Map.Entry valueEntry = (Map.Entry)object;
            String fieldName = valueEntry.getKey().toString();
            if (targetTypeField.containsKey(fieldName)) {
                if (TypeChecker.checkIsLikeType(valueEntry.getValue(), (Type)targetTypeField.get(fieldName), unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            if (!targetType.sealed) {
                if (TypeChecker.checkIsLikeType(valueEntry.getValue(), restFieldType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean checkFiniteTypeAssignable(Object sourceValue, Type sourceType, BFiniteType targetType) {
        if (sourceValue == null) {
            return false;
        }
        for (Object valueSpaceItem : targetType.valueSpace) {
            if (!TypeChecker.isFiniteTypeValue(sourceValue, sourceType, valueSpaceItem)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isFiniteTypeValue(Object sourceValue, Type sourceType, Object valueSpaceItem) {
        Type valueSpaceItemType = TypeChecker.getType(valueSpaceItem);
        if (valueSpaceItemType.getTag() > 3) {
            return valueSpaceItemType.getTag() == sourceType.getTag() && valueSpaceItem.equals(sourceValue);
        }
        switch (sourceType.getTag()) {
            case 1: 
            case 2: {
                return ((Number)sourceValue).longValue() == ((Number)valueSpaceItem).longValue();
            }
            case 3: {
                if (sourceType.getTag() != valueSpaceItemType.getTag()) {
                    return false;
                }
                return ((Number)sourceValue).doubleValue() == ((Number)valueSpaceItem).doubleValue();
            }
        }
        if (sourceType.getTag() != valueSpaceItemType.getTag()) {
            return false;
        }
        return valueSpaceItem.equals(sourceValue);
    }

    private static boolean checkIsErrorType(Type sourceType, BErrorType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 30) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BErrorType bErrorType = (BErrorType)sourceType;
        if (targetType.typeIdSet == null) {
            return TypeChecker.checkIsType(bErrorType.detailType, targetType.detailType, unresolvedTypes);
        }
        BTypeIdSet sourceTypeIdSet = bErrorType.typeIdSet;
        if (sourceTypeIdSet == null) {
            return false;
        }
        return sourceTypeIdSet.containsAll(targetType.typeIdSet);
    }

    private static boolean checkIsLikeErrorType(Object sourceValue, BErrorType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        Type sourceType = TypeChecker.getType(sourceValue);
        if (sourceValue == null || sourceType.getTag() != 30) {
            return false;
        }
        if (targetType.typeIdSet == null) {
            return TypeChecker.checkIsLikeType(((ErrorValue)sourceValue).getDetails(), targetType.detailType, unresolvedValues, allowNumericConversion);
        }
        BTypeIdSet sourceIdSet = ((BErrorType)sourceType).typeIdSet;
        if (sourceIdSet == null) {
            return false;
        }
        return sourceIdSet.containsAll(targetType.typeIdSet);
    }

    private static boolean isSimpleBasicType(Type type) {
        return type.getTag() < 7 || TypeTags.isIntegerTypeTag(type.getTag());
    }

    private static boolean isHandleType(Type type) {
        return type.getTag() == 38;
    }

    private static boolean isEqual(Object lhsValue, Object rhsValue, List<ValuePair> checkedValues) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (null == lhsValue || null == rhsValue) {
            return false;
        }
        int lhsValTypeTag = TypeChecker.getType(lhsValue).getTag();
        int rhsValTypeTag = TypeChecker.getType(rhsValue).getTag();
        switch (lhsValTypeTag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return lhsValue.equals(rhsValue);
            }
            case 1: {
                if (rhsValTypeTag <= 3) {
                    return lhsValue.equals(((Number)rhsValue).longValue());
                }
                if (rhsValTypeTag == 4) {
                    return DecimalValue.valueOf((Long)lhsValue).equals(rhsValue);
                }
                return false;
            }
            case 2: {
                if (rhsValTypeTag <= 3) {
                    return ((Number)lhsValue).byteValue() == ((Number)rhsValue).byteValue();
                }
                if (rhsValTypeTag == 4) {
                    return DecimalValue.valueOf((Integer)lhsValue).equals(rhsValue);
                }
                return false;
            }
            case 8: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return XmlFactory.isEqual((XmlValue)lhsValue, (XmlValue)rhsValue);
            }
            case 7: 
            case 12: 
            case 15: {
                return TypeChecker.isMappingType(rhsValTypeTag) && TypeChecker.isEqual((MapValueImpl)lhsValue, (MapValueImpl)rhsValue, checkedValues);
            }
            case 20: 
            case 32: {
                return TypeChecker.isListType(rhsValTypeTag) && TypeChecker.isEqual((ArrayValue)lhsValue, (ArrayValue)rhsValue, checkedValues);
            }
            case 30: {
                return rhsValTypeTag == 30 && TypeChecker.isEqual((ErrorValue)lhsValue, (ErrorValue)rhsValue, checkedValues);
            }
            case 19: {
                break;
            }
            case 9: {
                return rhsValTypeTag == 9 && TypeChecker.isEqual((TableValueImpl)lhsValue, (TableValueImpl)rhsValue, checkedValues);
            }
        }
        return false;
    }

    private static boolean isListType(int typeTag) {
        return typeTag == 20 || typeTag == 32;
    }

    private static boolean isMappingType(int typeTag) {
        return typeTag == 15 || typeTag == 12 || typeTag == 7;
    }

    private static boolean isEqual(ArrayValue lhsList, ArrayValue rhsList, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsList, rhsList);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsList.size() != rhsList.size()) {
            return false;
        }
        for (int i = 0; i < lhsList.size(); ++i) {
            if (TypeChecker.isEqual(lhsList.get(i), rhsList.get(i), checkedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(MapValueImpl lhsMap, MapValueImpl rhsMap, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsMap, rhsMap);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsMap.size() != rhsMap.size()) {
            return false;
        }
        if (!lhsMap.keySet().containsAll(rhsMap.keySet())) {
            return false;
        }
        for (Map.Entry lhsMapEntry : lhsMap.entrySet()) {
            if (TypeChecker.isEqual(lhsMapEntry.getValue(), rhsMap.get(lhsMapEntry.getKey()), checkedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(TableValueImpl lhsTable, TableValueImpl rhsTable, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsTable, rhsTable);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsTable.size() != rhsTable.size()) {
            return false;
        }
        if (((BTableType)lhsTable.getType()).getFieldNames() != null && ((BTableType)lhsTable.getType()).getFieldNames().length > 0) {
            for (Map.Entry entry : lhsTable.entrySet()) {
                if (TypeChecker.isEqual(entry.getValue(), rhsTable.get(entry.getKey()), checkedValues)) continue;
                return false;
            }
            return true;
        }
        return lhsTable.entrySet().equals(rhsTable.entrySet());
    }

    private static boolean isEqual(ErrorValue lhsError, ErrorValue rhsError, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsError, rhsError);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        return TypeChecker.isEqual(lhsError.getMessage(), rhsError.getMessage(), checkedValues) && TypeChecker.isEqual((MapValueImpl)lhsError.getDetails(), (MapValueImpl)rhsError.getDetails(), checkedValues) && TypeChecker.isEqual(lhsError.getCause(), rhsError.getCause(), checkedValues);
    }

    private static boolean isHandleValueRefEqual(Object lhsValue, Object rhsValue) {
        HandleValue lhsHandle = (HandleValue)lhsValue;
        HandleValue rhsHandle = (HandleValue)rhsValue;
        return lhsHandle.getValue() == rhsHandle.getValue();
    }

    public static boolean hasFillerValue(Type type) {
        return TypeChecker.hasFillerValue(type, new ArrayList<Type>());
    }

    private static boolean hasFillerValue(Type type, List<Type> unanalyzedTypes) {
        if (type == null) {
            return true;
        }
        if (type.getTag() < 12 || TypeTags.isIntegerTypeTag(type.getTag())) {
            return true;
        }
        switch (type.getTag()) {
            case 14: 
            case 15: 
            case 17: {
                return true;
            }
            case 20: {
                return TypeChecker.checkFillerValue((BArrayType)type);
            }
            case 34: {
                return TypeChecker.checkFillerValue((BFiniteType)type);
            }
            case 35: {
                return TypeChecker.checkFillerValue((BObjectType)type);
            }
            case 12: {
                return TypeChecker.checkFillerValue((BRecordType)type, unanalyzedTypes);
            }
            case 32: {
                BTupleType tupleType = (BTupleType)type;
                return tupleType.getTupleTypes().stream().allMatch(TypeChecker::hasFillerValue);
            }
            case 21: {
                return TypeChecker.checkFillerValue((BUnionType)type);
            }
        }
        return false;
    }

    private static boolean checkFillerValue(BUnionType type) {
        if (type.isNullable()) {
            return true;
        }
        Iterator<Type> iterator = type.getMemberTypes().iterator();
        Type firstMember = iterator.next();
        while (iterator.hasNext()) {
            if (TypeChecker.isSameType(firstMember, iterator.next())) continue;
            return false;
        }
        return TypeUtils.isValueType(firstMember) && TypeChecker.hasFillerValue(firstMember);
    }

    private static boolean checkFillerValue(BRecordType type, List<Type> unAnalyzedTypes) {
        if (unAnalyzedTypes.contains(type)) {
            return true;
        }
        unAnalyzedTypes.add(type);
        for (Field field : type.getFields().values()) {
            if (SymbolFlags.isFlagOn(field.getFlags(), 4096L) || !SymbolFlags.isFlagOn(field.getFlags(), 256L)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFillerValue(BArrayType type) {
        return type.getState() == ArrayType.ArrayState.OPEN || TypeChecker.hasFillerValue(type.getElementType());
    }

    private static boolean checkFillerValue(BObjectType type) {
        if (type.getTag() == 19) {
            return false;
        }
        AttachedFunctionType generatedInitializer = type.generatedInitializer;
        if (generatedInitializer == null) {
            return false;
        }
        FunctionType initFuncType = generatedInitializer.getType();
        boolean noParams = initFuncType.getParameterTypes().length == 0;
        boolean nilReturn = initFuncType.getReturnType().getTag() == 10;
        return noParams && nilReturn;
    }

    private static boolean checkFillerValue(BFiniteType type) {
        for (Object value : type.valueSpace) {
            if (value != null) continue;
            return true;
        }
        if (type.valueSpace.size() == 1) {
            return true;
        }
        Object firstElement = type.valueSpace.iterator().next();
        for (Object value : type.valueSpace) {
            if (value.getClass() == firstElement.getClass()) continue;
            return false;
        }
        if (firstElement instanceof String) {
            return TypeChecker.containsElement(type.valueSpace, "\"\"");
        }
        if (firstElement instanceof Byte || firstElement instanceof Integer || firstElement instanceof Long) {
            return TypeChecker.containsElement(type.valueSpace, "0");
        }
        if (firstElement instanceof Float || firstElement instanceof Double || firstElement instanceof BigDecimal) {
            return TypeChecker.containsElement(type.valueSpace, "0.0");
        }
        if (firstElement instanceof Boolean) {
            return TypeChecker.containsElement(type.valueSpace, "false");
        }
        return false;
    }

    private static boolean containsElement(Set<Object> valueSpace, String e) {
        for (Object value : valueSpace) {
            if (value == null || !value.toString().equals(e)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsType(Set<Object> valueSpace, Type type) {
        for (Object value : valueSpace) {
            if (TypeChecker.isSameType(type, TypeChecker.getType(value))) continue;
            return false;
        }
        return true;
    }

    private static class ValuePair {
        ArrayList<Object> valueList = new ArrayList(2);

        ValuePair(Object valueOne, Object valueTwo) {
            this.valueList.add(valueOne);
            this.valueList.add(valueTwo);
        }

        public boolean equals(Object otherPair) {
            if (!(otherPair instanceof ValuePair)) {
                return false;
            }
            ArrayList<Object> otherList = ((ValuePair)otherPair).valueList;
            ArrayList<Object> currentList = this.valueList;
            if (otherList.size() != currentList.size()) {
                return false;
            }
            for (int i = 0; i < otherList.size(); ++i) {
                if (otherList.get(i).equals(currentList.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class TypePair {
        Type sourceType;
        Type targetType;

        public TypePair(Type sourceType, Type targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
        }
    }
}

