/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.services;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.services.spi.EmbeddedExecutor;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.util.ArgumentParser;
import io.ballerina.runtime.internal.util.RuntimeUtils;
import io.ballerina.runtime.internal.util.exceptions.BLangRuntimeException;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.FutureValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;

public class JVMEmbeddedExecutor
implements EmbeddedExecutor {
    private static final String MODULE_INIT_CLASS = ".$_init";

    @Override
    public Optional<RuntimeException> executeMainFunction(String moduleName, String moduleVersion, String strandName, StrandMetadata metaData, String[] args) {
        try {
            Scheduler scheduler = new Scheduler(false);
            JVMEmbeddedExecutor.runInitOnSchedule(moduleName, moduleVersion, scheduler, strandName, metaData);
            JVMEmbeddedExecutor.runMainOnSchedule(moduleName, moduleVersion, scheduler, strandName, metaData, args);
            scheduler.setImmortal(true);
            new Thread(scheduler::start).start();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e);
        }
    }

    @Override
    public Optional<RuntimeException> executeService(String moduleName, String moduleVersion, String strandName, StrandMetadata metaData) {
        try {
            Scheduler scheduler = new Scheduler(false);
            JVMEmbeddedExecutor.runInitOnSchedule(moduleName, moduleVersion, scheduler, strandName, metaData);
            this.runStartOnSchedule(moduleName, moduleVersion, scheduler, strandName, metaData);
            scheduler.setImmortal(true);
            new Thread(scheduler::start).start();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e);
        }
    }

    private void runStartOnSchedule(String moduleName, String moduleVersion, Scheduler scheduler, String strandName, StrandMetadata metaData) throws RuntimeException {
        try {
            Class<?> initClazz = Class.forName("ballerina." + moduleName + "." + moduleVersion.replace(".", "_") + MODULE_INIT_CLASS);
            Method initMethod = initClazz.getDeclaredMethod("$moduleStart", Strand.class);
            Function<Object[], Object> func = objects -> {
                try {
                    return initMethod.invoke(null, objects[0]);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(new Object[1], func, null, null, null, PredefinedTypes.TYPE_NULL, strandName, metaData);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }

    private static void runMainOnSchedule(String moduleName, String moduleVersion, Scheduler scheduler, String strandName, StrandMetadata metaData, String[] stringArgs) throws RuntimeException {
        try {
            Class<?> mainClass = Class.forName("ballerina." + moduleName + "." + moduleVersion.replace(".", "_") + "." + moduleName);
            Method mainMethod = mainClass.getDeclaredMethod("main", Strand.class, ArrayValue.class, Boolean.TYPE);
            Object[] entryFuncArgs = ArgumentParser.extractEntryFuncArgs(new RuntimeUtils.ParamInfo[]{new RuntimeUtils.ParamInfo(false, "%1", new BArrayType((Type)PredefinedTypes.TYPE_STRING, stringArgs.length))}, stringArgs, true);
            Function<Object[], Object> func = objects -> {
                try {
                    return mainMethod.invoke(null, entryFuncArgs);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(entryFuncArgs, func, null, null, null, PredefinedTypes.TYPE_NULL, strandName, metaData);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }

    private static void runInitOnSchedule(String moduleName, String moduleVersion, Scheduler scheduler, String strandName, StrandMetadata metaData) throws RuntimeException {
        try {
            Class<?> initClazz = Class.forName("ballerina." + moduleName + "." + moduleVersion.replace(".", "_") + MODULE_INIT_CLASS);
            Method initMethod = initClazz.getDeclaredMethod("$moduleInit", Strand.class);
            Function<Object[], Object> func = objects -> {
                try {
                    return initMethod.invoke(null, objects[0]);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(new Object[1], func, null, null, null, PredefinedTypes.TYPE_NULL, strandName, metaData);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }
}

