/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import java.util.Arrays;

public class BFunctionType
extends BAnnotatableType
implements FunctionType {
    public Type[] paramTypes;
    public Type restType;
    public Type retType;
    public long flags;

    public BFunctionType() {
        super("function ()", (Module)null, Object.class);
        this.paramTypes = new Type[0];
        this.retType = PredefinedTypes.TYPE_NULL;
        this.flags = 0L;
    }

    public BFunctionType(Type[] paramTypes, Type restType, Type retType, long flags) {
        super("function ()", (Module)null, Object.class);
        this.paramTypes = paramTypes;
        this.restType = restType;
        this.retType = retType;
        this.flags = flags;
    }

    @Override
    public Type[] getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public Type getReturnParameterType() {
        return this.retType;
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 37;
    }

    private static String getTypeListAsString(Type[] typeNames) {
        StringBuffer br = new StringBuffer();
        int i = 0;
        for (Type type : typeNames) {
            br.append(type.getName());
            if (++i >= typeNames.length) continue;
            br.append(",");
        }
        return br.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BFunctionType that = (BFunctionType)o;
        if (SymbolFlags.isFlagOn(that.flags, 0x20000000L) != SymbolFlags.isFlagOn(this.flags, 0x20000000L)) {
            return false;
        }
        if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
            return false;
        }
        return this.retType.equals(that.retType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + this.retType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        String stringRep = "function (" + (this.paramTypes != null ? BFunctionType.getTypeListAsString(this.paramTypes) : "") + ")" + (String)(this.retType != null ? " returns (" + this.retType + ")" : "");
        if (SymbolFlags.isFlagOn(this.flags, 0x20000000L)) {
            return "isolated " + stringRep;
        }
        return stringRep;
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Type[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public Type getRestType() {
        return this.restType;
    }

    @Override
    public Type getReturnType() {
        return this.retType;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }
}

