/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.AttachedFunctionType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.AttachedFunction;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import java.util.Map;
import java.util.StringJoiner;

public class BObjectType
extends BStructureType
implements ObjectType {
    private AttachedFunctionType[] attachedFunctions;
    public AttachedFunctionType initializer;
    public AttachedFunctionType generatedInitializer;
    private final boolean readonly;
    private IntersectionType immutableType;
    public BTypeIdSet typeIdSet;

    public BObjectType(String typeName, Module pkg, long flags) {
        super(typeName, pkg, flags, Object.class);
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
    }

    @Override
    public <V> V getZeroValue() {
        return (V)ValueCreator.createObjectValue(this.pkg, this.typeName, new Object[0]);
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 35;
    }

    @Override
    public AttachedFunctionType[] getAttachedFunctions() {
        return this.attachedFunctions;
    }

    @Override
    public void setAttachedFunctions(AttachedFunctionType[] attachedFunctions) {
        this.attachedFunctions = attachedFunctions;
    }

    public void setInitializer(AttachedFunction initializer) {
        this.initializer = initializer;
    }

    public void setGeneratedInitializer(AttachedFunction generatedInitializer) {
        this.generatedInitializer = generatedInitializer;
    }

    @Override
    public String toString() {
        String name;
        String string = name = this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
        if (!this.typeName.contains("$anon")) {
            return name;
        }
        StringJoiner sj = new StringJoiner(",\n\t", name + " {\n\t", "\n}");
        for (Map.Entry<String, Field> field : this.getFields().entrySet()) {
            sj.add(field.getKey() + " : " + field.getValue().getFieldType());
        }
        for (AttachedFunctionType func : this.attachedFunctions) {
            sj.add(func.toString());
        }
        return sj.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    public void setTypeIdSet(BTypeIdSet typeIdSet) {
        this.typeIdSet = typeIdSet;
    }
}

