/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.util.Map;

public class BRecordType
extends BStructureType
implements RecordType {
    public boolean sealed;
    public Type restFieldType;
    public int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BRecordType(String typeName, Module pkg, long flags, boolean sealed, int typeFlags) {
        super(typeName, pkg, flags, MapValueImpl.class);
        this.sealed = sealed;
        this.typeFlags = typeFlags;
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
    }

    public BRecordType(String typeName, Module pkg, long flags, Map<String, Field> fields, Type restFieldType, boolean sealed, int typeFlags) {
        super(typeName, pkg, flags, MapValueImpl.class, fields);
        this.restFieldType = restFieldType;
        this.sealed = sealed;
        this.typeFlags = typeFlags;
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
    }

    @Override
    public <V> V getZeroValue() {
        return (V)ValueCreator.createRecordValue(this.pkg, this.typeName);
    }

    @Override
    public <V> V getEmptyValue() {
        MapValueImpl implicitInitValue = new MapValueImpl(this);
        this.fields.entrySet().stream().filter(entry -> !SymbolFlags.isFlagOn(((Field)entry.getValue()).getFlags(), 4096L)).forEach(entry -> {
            Object value = ((Field)entry.getValue()).getFieldType().getEmptyValue();
            implicitInitValue.put(StringUtils.fromString((String)entry.getKey()), value);
        });
        return (V)implicitInitValue;
    }

    @Override
    public int getTag() {
        return 12;
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public Type getRestFieldType() {
        return this.restFieldType;
    }

    @Override
    public int getTypeFlags() {
        return this.typeFlags;
    }
}

