/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.IdentifierUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import java.util.Objects;

public abstract class BType
implements Type {
    protected String typeName;
    protected Module pkg;
    protected Class<? extends Object> valueClass;
    private int hashCode;

    protected BType(String typeName, Module pkg, Class<? extends Object> valueClass) {
        this.typeName = IdentifierUtils.decodeIdentifier(typeName);
        this.pkg = pkg;
        this.valueClass = valueClass;
        if (pkg != null && typeName != null) {
            this.hashCode = Objects.hash(pkg, typeName);
        }
    }

    public <V> Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public abstract <V> V getZeroValue();

    @Override
    public abstract <V> V getEmptyValue();

    @Override
    public abstract int getTag();

    @Override
    public String toString() {
        return this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BType) {
            BType other = (BType)obj;
            if (!this.typeName.equals(other.getName())) {
                return false;
            }
            Module thisModule = this.pkg;
            Module otherModule = other.pkg;
            if (thisModule == null) {
                return otherModule == null;
            }
            if (otherModule == null) {
                return false;
            }
            if (this.hasAllNullConstituents(thisModule)) {
                return this.hasAllNullConstituents(otherModule);
            }
            if (this.hasAllNullConstituents(otherModule)) {
                return false;
            }
            if (thisModule.getVersion() == null || otherModule.getVersion() == null) {
                return thisModule.getOrg().equals(otherModule.getOrg()) && thisModule.getName().equals(otherModule.getName());
            }
            return thisModule.equals(otherModule);
        }
        return false;
    }

    @Override
    public boolean isNilable() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public String getQualifiedName() {
        return this.pkg == null ? this.typeName : this.pkg.toString() + ":" + this.typeName;
    }

    @Override
    public Module getPackage() {
        return this.pkg;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isAnydata() {
        return this.getTag() <= 11;
    }

    @Override
    public boolean isPureType() {
        return this.getTag() == 30 || this.isAnydata();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Type getImmutableType() {
        if (TypeChecker.isInherentlyImmutableType(this)) {
            return this;
        }
        throw new BallerinaException(this.typeName + " cannot be immutable");
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
    }

    private boolean hasAllNullConstituents(Module module) {
        return module.getOrg() == null && module.getName() == null && module.getVersion() == null;
    }

    @Override
    public Module getPkg() {
        return this.pkg;
    }
}

