/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlValue;

public class BXmlType
extends BType
implements XmlType {
    private final int tag;
    public Type constraint;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BXmlType(String typeName, Type constraint, Module pkg) {
        super(typeName, pkg, XmlValue.class);
        this.constraint = constraint;
        this.tag = 8;
        this.readonly = false;
    }

    public BXmlType(String typeName, Module pkg, int tag, boolean readonly) {
        super(typeName, pkg, XmlValue.class);
        this.tag = tag;
        this.readonly = readonly;
    }

    public BXmlType(Type constraint, boolean readonly) {
        super("xml", null, XmlValue.class);
        this.tag = 8;
        this.constraint = constraint;
        this.readonly = readonly;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new XmlSequence();
    }

    @Override
    public <V> V getEmptyValue() {
        return (V)new XmlSequence();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    @Override
    public boolean isAnydata() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this != obj || !(obj instanceof BXmlType)) {
            return false;
        }
        BXmlType other = (BXmlType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        return this.readonly == other.readonly && this.constraint.equals(other.constraint);
    }

    @Override
    public String toString() {
        if (this.constraint != null) {
            return "xml<" + this.constraint + ">";
        }
        return super.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

