/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.util;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.JsonParser;
import io.ballerina.runtime.internal.JsonUtils;
import io.ballerina.runtime.internal.XmlFactory;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.util.RuntimeUtils;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArgumentParser {
    private static final String DEFAULT_PARAM_PREFIX = "-";
    private static final String NAMED_ARG_DELIMITER = "=";
    private static final String INVALID_ARG = "invalid argument: ";
    private static final String INVALID_ARG_AS_REST_ARG = "invalid argument as rest argument: ";
    private static final String UNSUPPORTED_TYPE_PREFIX = "unsupported type expected with entry function";
    private static final String JSON_PARSER_ERROR = "at line: ";
    private static final String COMMA = ",";
    private static final String NIL = "()";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String HEX_PREFIX = "0X";

    public static Object[] extractEntryFuncArgs(RuntimeUtils.ParamInfo[] funcInfo, String[] args, boolean hasRestParam) {
        Object[] bValueArgs = null;
        try {
            bValueArgs = ArgumentParser.getEntryFuncArgs(funcInfo, args, hasRestParam);
        }
        catch (ErrorValue e) {
            RuntimeUtils.handleUsageError(e.getMessage());
        }
        return bValueArgs;
    }

    private static Object[] getEntryFuncArgs(RuntimeUtils.ParamInfo[] funcInfo, String[] args, boolean hasRestParam) {
        int i;
        Object[] bValueArgs = new Object[funcInfo.length * 2 + 1];
        HashMap<String, RuntimeUtils.ParamInfo> namedArgs = new HashMap<String, RuntimeUtils.ParamInfo>();
        boolean isNamedArgFound = false;
        int defaultableCount = 0;
        for (int i2 = 0; i2 < funcInfo.length; ++i2) {
            RuntimeUtils.ParamInfo info = funcInfo[i2];
            info.index = i2;
            namedArgs.put(info.name, info);
            if (!info.hasDefaultable) continue;
            ++defaultableCount;
        }
        int argsCountExceptRestArgs = hasRestParam ? funcInfo.length - 1 : funcInfo.length;
        int requiredParamsCount = hasRestParam ? argsCountExceptRestArgs - defaultableCount : argsCountExceptRestArgs - defaultableCount;
        ArrayList<String> restArgs = new ArrayList<String>();
        int providedRequiredArgsCount = 0;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean isNameArg = ArgumentParser.isNameArg(arg);
            if (isNameArg) {
                isNamedArgFound = true;
                String paramName = ArgumentParser.getParamName(arg);
                RuntimeUtils.ParamInfo info = (RuntimeUtils.ParamInfo)namedArgs.get(paramName);
                if (info == null) {
                    throw ErrorCreator.createError(StringUtils.fromString("undefined parameter: '" + paramName + "'"));
                }
                bValueArgs[info.index * 2 + 1] = ArgumentParser.getBValue(info.type, ArgumentParser.getValueString(arg));
                bValueArgs[info.index * 2 + 2] = true;
                if (info.hasDefaultable) continue;
                ++providedRequiredArgsCount;
                continue;
            }
            if (isNamedArgFound) {
                throw ErrorCreator.createError(StringUtils.fromString("positional argument not allowed after named arguments when calling the 'main' function"));
            }
            if (i < argsCountExceptRestArgs) {
                RuntimeUtils.ParamInfo info = funcInfo[i];
                bValueArgs[2 * i + 1] = ArgumentParser.getBValue(info.type, arg);
                bValueArgs[2 * i + 2] = true;
                if (info.hasDefaultable) continue;
                ++providedRequiredArgsCount;
                continue;
            }
            restArgs.add(arg);
        }
        if (providedRequiredArgsCount < requiredParamsCount) {
            throw ErrorCreator.createError(StringUtils.fromString("insufficient arguments to call the 'main' function"));
        }
        if (!hasRestParam && !restArgs.isEmpty()) {
            throw ErrorCreator.createError(StringUtils.fromString("too many arguments to call the 'main' function"));
        }
        if (hasRestParam) {
            bValueArgs[funcInfo.length * 2 - 1] = ArgumentParser.getRestArgArray(funcInfo[funcInfo.length - 1].type, restArgs);
            bValueArgs[funcInfo.length * 2] = true;
        }
        for (i = requiredParamsCount; i < argsCountExceptRestArgs; ++i) {
            int defaultableArgIndex = i * 2 + 1;
            if (bValueArgs[defaultableArgIndex + 1] != null) continue;
            bValueArgs[defaultableArgIndex + 1] = false;
            bValueArgs[defaultableArgIndex] = ArgumentParser.getDefaultBValue(funcInfo[i].type);
        }
        return bValueArgs;
    }

    private static boolean isNameArg(String arg) {
        return arg.startsWith(DEFAULT_PARAM_PREFIX) && arg.contains(NAMED_ARG_DELIMITER);
    }

    private static String getParamName(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[0].substring(1).trim();
    }

    private static String getValueString(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[1];
    }

    private static Object getBValue(Type type, String value) {
        switch (type.getTag()) {
            case 5: 
            case 17: {
                return StringUtils.fromString(value);
            }
            case 1: {
                return ArgumentParser.getIntegerValue(value);
            }
            case 3: {
                return ArgumentParser.getFloatValue(value);
            }
            case 4: {
                return ArgumentParser.getDecimalValue(value);
            }
            case 6: {
                return ArgumentParser.getBooleanValue(value);
            }
            case 2: {
                return ArgumentParser.getByteValue(value);
            }
            case 8: {
                try {
                    return XmlFactory.parse(value);
                }
                catch (RuntimeException e) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', expected XML value"));
                }
            }
            case 7: {
                try {
                    return JsonParser.parse(value);
                }
                catch (BError e) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', expected JSON value"));
                }
            }
            case 12: {
                try {
                    return JsonUtils.convertJSONToRecord(JsonParser.parse(value), (BStructureType)type);
                }
                catch (BError e) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', error constructing record of type: " + type + ": " + e.getLocalizedMessage().split(JSON_PARSER_ERROR)[0]));
                }
            }
            case 32: {
                if (!value.startsWith("[") || !value.endsWith("]")) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', expected tuple notation [\"[]\"] with tuple arg"));
                }
                return ArgumentParser.parseTupleArg((BTupleType)type, value.substring(1, value.length() - 1));
            }
            case 20: {
                try {
                    return JsonUtils.convertJSONToBArray(JsonParser.parse(value), (BArrayType)type);
                }
                catch (BallerinaException | ErrorValue e) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', expected array elements of type: " + ((BArrayType)type).getElementType()));
                }
            }
            case 15: {
                try {
                    return JsonUtils.jsonToMap(JsonParser.parse(value), (BMapType)type);
                }
                catch (BallerinaException | ErrorValue e) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + value + "', expected map argument of element type: " + ((BMapType)type).getConstrainedType()));
                }
            }
            case 21: {
                return ArgumentParser.parseUnionArg((BUnionType)type, value);
            }
        }
        throw ErrorCreator.createError(StringUtils.fromString("unsupported type expected with entry function '" + type + "'"));
    }

    private static Object getDefaultBValue(Type type) {
        switch (type.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
            case 6: {
                return false;
            }
        }
        return null;
    }

    private static long getIntegerValue(String argument) {
        try {
            if (argument.toUpperCase().startsWith(HEX_PREFIX)) {
                return Long.parseLong(argument.toUpperCase().replace(HEX_PREFIX, ""), 16);
            }
            return Long.parseLong(argument);
        }
        catch (NumberFormatException e) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected integer value"));
        }
    }

    private static double getFloatValue(String argument) {
        try {
            return Double.parseDouble(argument);
        }
        catch (NumberFormatException e) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected float value"));
        }
    }

    private static DecimalValue getDecimalValue(String argument) {
        try {
            return new DecimalValue(argument);
        }
        catch (NumberFormatException e) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected decimal value"));
        }
    }

    private static boolean getBooleanValue(String argument) {
        if (!TRUE.equalsIgnoreCase(argument) && !FALSE.equalsIgnoreCase(argument)) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected boolean value 'true' or 'false'"));
        }
        return Boolean.parseBoolean(argument);
    }

    private static int getByteValue(String argument) {
        int byteValue;
        try {
            byteValue = Integer.parseInt(argument);
        }
        catch (NumberFormatException e) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected byte value"));
        }
        if (!RuntimeUtils.isByteLiteral(byteValue)) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + argument + "', expected byte value, found int"));
        }
        return byteValue;
    }

    private static ArrayValue getRestArgArray(Type type, List<String> args) {
        Type elementType = ((BArrayType)type).getElementType();
        try {
            switch (elementType.getTag()) {
                case 5: 
                case 17: {
                    ArrayValueImpl stringArrayArgs = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_STRING));
                    for (int i = 0; i < args.size(); ++i) {
                        stringArrayArgs.add((long)i, args.get(i));
                    }
                    return stringArrayArgs;
                }
                case 1: {
                    ArrayValueImpl intArrayArgs = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_INT));
                    for (int i = 0; i < args.size(); ++i) {
                        intArrayArgs.add((long)i, ArgumentParser.getIntegerValue(args.get(i)));
                    }
                    return intArrayArgs;
                }
                case 3: {
                    ArrayValueImpl floatArrayArgs = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_FLOAT));
                    for (int i = 0; i < args.size(); ++i) {
                        floatArrayArgs.add((long)i, ArgumentParser.getFloatValue(args.get(i)));
                    }
                    return floatArrayArgs;
                }
                case 6: {
                    ArrayValueImpl booleanArrayArgs = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_BOOLEAN));
                    for (int i = 0; i < args.size(); ++i) {
                        booleanArrayArgs.add((long)i, ArgumentParser.getBooleanValue(args.get(i)) ? 1L : 0L);
                    }
                    return booleanArrayArgs;
                }
                case 2: {
                    ArrayValueImpl byteArrayArgs = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_BYTE));
                    for (int i = 0; i < args.size(); ++i) {
                        byteArrayArgs.add((long)i, (byte)ArgumentParser.getByteValue(args.get(i)));
                    }
                    return byteArrayArgs;
                }
            }
            ArrayValueImpl refValueArray = new ArrayValueImpl((BArrayType)type);
            for (int i = 0; i < args.size(); ++i) {
                refValueArray.add((long)i, ArgumentParser.getBValue(elementType, args.get(i)));
            }
            return refValueArray;
        }
        catch (BallerinaException e) {
            throw ErrorCreator.createError(StringUtils.fromString(e.getLocalizedMessage().replace(INVALID_ARG, INVALID_ARG_AS_REST_ARG)));
        }
        catch (Exception e) {
            throw ErrorCreator.createError(StringUtils.fromString("error parsing rest arg: " + e.getLocalizedMessage()));
        }
    }

    private static ArrayValue parseTupleArg(BTupleType type, String tupleArg) {
        String stringSpecificationErrorSuffix = "', expected argument in the format \\\"str\\\" for tuple element of type 'string'";
        String[] tupleElements = tupleArg.split(COMMA);
        if (tupleElements.length != type.getTupleTypes().size()) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid argument '[" + tupleArg + "]', element count mismatch for tuple type: '" + type + "'"));
        }
        TupleValueImpl tupleValues = new TupleValueImpl(type);
        int index = 0;
        for (Type elementType : type.getTupleTypes()) {
            String tupleElement = tupleElements[index].trim();
            try {
                if (elementType.getTag() == 5) {
                    if (!tupleElement.startsWith("\"") || !tupleElement.endsWith("\"")) {
                        throw ErrorCreator.createError(StringUtils.fromString("invalid tuple element argument '" + tupleElement + stringSpecificationErrorSuffix));
                    }
                    tupleElement = tupleElement.substring(1, tupleElement.length() - 1);
                }
                tupleValues.add((long)index, ArgumentParser.getBValue(elementType, tupleElement));
                ++index;
            }
            catch (BallerinaException | ErrorValue e) {
                String localizedMessage = e.getLocalizedMessage();
                if (localizedMessage.startsWith(UNSUPPORTED_TYPE_PREFIX)) {
                    throw ErrorCreator.createError(StringUtils.fromString("unsupported element type for tuple as entry function argument: " + elementType));
                }
                if (!localizedMessage.endsWith(stringSpecificationErrorSuffix)) {
                    throw ErrorCreator.createError(StringUtils.fromString("invalid tuple member argument '" + tupleElement + "', expected value of type '" + elementType + "'"));
                }
                throw e;
            }
        }
        return tupleValues;
    }

    private static Object parseUnionArg(BUnionType type, String unionArg) {
        List<Type> unionMemberTypes = type.getMemberTypes();
        if (unionMemberTypes.contains(PredefinedTypes.TYPE_NULL) && NIL.equals(unionArg)) {
            return null;
        }
        if (unionMemberTypes.contains(PredefinedTypes.TYPE_STRING)) {
            return ArgumentParser.getBValue(PredefinedTypes.TYPE_STRING, unionArg);
        }
        int memberTypeIndex = 0;
        while (memberTypeIndex < unionMemberTypes.size()) {
            try {
                Type memberType = unionMemberTypes.get(memberTypeIndex);
                if (memberType.getTag() == 10) {
                    ++memberTypeIndex;
                    continue;
                }
                return ArgumentParser.getBValue(memberType, unionArg);
            }
            catch (ErrorValue e) {
                ++memberTypeIndex;
            }
        }
        throw ErrorCreator.createError(StringUtils.fromString("invalid argument '" + unionArg + "' specified for union type: " + (type.isNilable() ? type.toString().replace("|null", "|()") : type)));
    }
}

