/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.IteratorUtils;
import io.ballerina.runtime.internal.JsonGenerator;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class AbstractArrayValue
implements ArrayValue {
    static final int SYSTEM_ARRAY_MAX = 0x7FFFFFF7;
    protected int maxSize = 0x7FFFFFF7;
    protected static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;
    protected Type iteratorNextReturnType;

    @Override
    public abstract Object get(long var1);

    @Override
    public abstract Object getRefValue(long var1);

    @Override
    public abstract long getInt(long var1);

    @Override
    public abstract boolean getBoolean(long var1);

    @Override
    public abstract byte getByte(long var1);

    @Override
    public abstract double getFloat(long var1);

    @Override
    @Deprecated
    public abstract String getString(long var1);

    @Override
    public abstract void add(long var1, Object var3);

    @Override
    public abstract void add(long var1, long var3);

    @Override
    public abstract void add(long var1, boolean var3);

    @Override
    public abstract void add(long var1, byte var3);

    @Override
    public abstract void add(long var1, double var3);

    @Override
    @Deprecated
    public abstract void add(long var1, String var3);

    @Override
    public abstract void add(long var1, BString var3);

    @Override
    public void append(Object value) {
        this.add((long)this.size, value);
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public abstract Object shift(long var1);

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public abstract String stringValue(BLink var1);

    @Override
    public abstract String expressionStringValue(BLink var1);

    @Override
    public abstract Type getType();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public abstract Object copy(Map<Object, Object> var1);

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public abstract void serialize(OutputStream var1);

    @Override
    public String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JsonGenerator gen = new JsonGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    @Override
    public abstract void freezeDirect();

    @Override
    public IteratorValue getIterator() {
        return new ArrayIterator(this);
    }

    @Override
    public void setLength(long length) {
        if (length == (long)this.size) {
            return;
        }
        this.handleImmutableArrayValue();
        int newLength = (int)length;
        this.checkFixedLength(length);
        this.rangeCheck(length, this.size);
        this.fillerValueCheck(newLength, this.size);
        this.resizeInternalArray(newLength);
        this.fillValues(newLength);
        this.size = newLength;
    }

    @Override
    public long getLength() {
        return this.size;
    }

    protected void initializeIteratorNextReturnType() {
        Type type;
        if (this.getType().getTag() == 20) {
            type = this.getElementType();
        } else {
            BTupleType tupleType = (BTupleType)this.getType();
            LinkedHashSet<Type> types = new LinkedHashSet<Type>(tupleType.getTupleTypes());
            if (tupleType.getRestType() != null) {
                types.add(tupleType.getRestType());
            }
            type = types.size() == 1 ? (Type)types.iterator().next() : new BUnionType(new ArrayList<Type>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected abstract void fillValues(int var1);

    protected abstract void fillerValueCheck(int var1, int var2);

    protected abstract void resizeInternalArray(int var1);

    protected abstract void rangeCheckForGet(long var1, int var3);

    protected abstract void rangeCheck(long var1, int var3);

    protected void handleImmutableArrayValue() {
        if (!this.getType().isReadOnly()) {
            return;
        }
        throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InvalidUpdate"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
    }

    protected void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    protected abstract void ensureCapacity(int var1, int var2);

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    protected abstract void unshift(long var1, Object[] var3);

    protected abstract void checkFixedLength(long var1);

    static class ArrayIterator
    implements IteratorValue {
        ArrayValue array;
        long cursor = 0L;
        long length;

        ArrayIterator(ArrayValue value) {
            this.array = value;
            this.length = value.size();
        }

        public Object next() {
            long cursor;
            if ((cursor = this.cursor++) == this.length) {
                return null;
            }
            return this.array.get(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }
    }
}

