/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ObjectValue;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public abstract class AbstractObjectValue
implements ObjectValue {
    private BObjectType type;
    private final HashMap<String, Object> nativeData = new HashMap();

    public AbstractObjectValue(BObjectType type) {
        this.type = type;
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public HashMap<String, Object> getNativeData() {
        return this.nativeData;
    }

    @Override
    public long getIntValue(BString fieldName) {
        return (Long)this.get(fieldName);
    }

    @Override
    public double getFloatValue(BString fieldName) {
        return (Double)this.get(fieldName);
    }

    @Override
    public BString getStringValue(BString fieldName) {
        return (BString)this.get(fieldName);
    }

    @Override
    public String stringValue(BLink parent) {
        return "object " + this.type.toString();
    }

    @Override
    public String informalStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        Module pkg = this.type.getPackage();
        String moduleLocalName = pkg.getOrg() != null && pkg.getOrg().equals("$anon") || pkg.getName() == null ? this.type.getName() : String.valueOf(BallerinaErrorReasons.getModulePrefixedReason(pkg.getName(), this.type.getName()));
        return "object " + moduleLocalName + " " + this.hashCode();
    }

    @Override
    public boolean getBooleanValue(BString fieldName) {
        return (Boolean)this.get(fieldName);
    }

    @Override
    public BMap getMapValue(BString fieldName) {
        return (MapValueImpl)this.get(fieldName);
    }

    @Override
    public BObject getObjectValue(BString fieldName) {
        return (BObject)this.get(fieldName);
    }

    @Override
    public BArray getArrayValue(BString fieldName) {
        return (ArrayValue)this.get(fieldName);
    }

    @Override
    public ObjectType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (Map.Entry<String, Field> field : this.type.getFields().entrySet()) {
            if (!SymbolFlags.isFlagOn(field.getValue().getFlags(), 1L)) continue;
            String fieldName = field.getKey();
            sj.add(fieldName + ":" + this.getStringValue(this.get(StringUtils.fromString(fieldName))));
        }
        return sj.toString();
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + value.toString() + "\"";
        }
        return value.toString();
    }

    protected void checkFieldUpdateOnInitialization(String fieldName, Object value) {
        this.checkFieldUpdateType(fieldName, value);
    }

    protected void checkFieldUpdate(String fieldName, Object value) {
        if (this.type.isReadOnly()) {
            throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.object", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
        }
        Field field = this.type.getFields().get(fieldName);
        if (SymbolFlags.isFlagOn(field.getFlags(), 4L)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.object", "InvalidUpdate"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.OBJECT_INVALID_FINAL_FIELD_UPDATE, fieldName, this.type));
        }
        this.checkFieldUpdateType(fieldName, value);
    }

    private void checkFieldUpdateType(String fieldName, Object value) {
        Type fieldType = this.type.getFields().get(fieldName).getFieldType();
        if (TypeChecker.checkIsType(value, fieldType)) {
            return;
        }
        throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.object", "InherentTypeViolation"), StringUtils.fromString("invalid value for object field '" + fieldName + "': expected value of type '" + fieldType + "', found '" + TypeChecker.getType(value) + "'"));
    }
}

