/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.async.Callback;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BFutureType;
import io.ballerina.runtime.internal.values.RefValue;
import java.util.Map;
import java.util.StringJoiner;

public class FutureValue
implements BFuture,
RefValue {
    public Strand strand;
    public Object result;
    public boolean isDone;
    public Throwable panic;
    public Callback callback;
    Type type;

    @Deprecated
    public FutureValue(Strand strand, Callback callback, Type constraint) {
        this.strand = strand;
        this.callback = callback;
        this.type = new BFutureType(constraint);
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",", "{", "}");
        sj.add("isDone:" + this.isDone);
        if (this.isDone) {
            sj.add("result:" + this.result.toString());
        }
        if (this.panic != null) {
            sj.add("panic:" + this.panic.getLocalizedMessage());
        }
        return "future " + sj.toString();
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() {
        this.strand.cancel = true;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public Throwable getPanic() {
        return this.panic;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    public String toString() {
        return this.stringValue(null);
    }
}

