/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BLangFreezeException;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReadOnlyUtils {
    static void handleInvalidUpdate(String moduleName) {
        throw new BLangFreezeException(BallerinaErrorReasons.getModulePrefixedReason(moduleName, "InvalidUpdate").getValue(), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_READONLY_VALUE_UPDATE, new Object[0]).getValue());
    }

    public static Type setImmutableTypeAndGetEffectiveType(Type type) {
        if (TypeChecker.isInherentlyImmutableType(type)) {
            return type;
        }
        if (type.getTag() == 22 && type.isReadOnly()) {
            return ((BIntersectionType)type).getEffectiveType();
        }
        Type immutableType = type.getImmutableType();
        if (immutableType != null) {
            return ((BIntersectionType)immutableType).getEffectiveType();
        }
        return ReadOnlyUtils.setImmutableIntersectionType(type, new HashSet<Type>()).getEffectiveType();
    }

    private static Type getImmutableType(Type type, Set<Type> unresolvedTypes) {
        if (TypeChecker.isInherentlyImmutableType(type)) {
            return type;
        }
        return ReadOnlyUtils.setImmutableIntersectionType(type, unresolvedTypes);
    }

    private static BIntersectionType setImmutableIntersectionType(Type type, Set<Type> unresolvedTypes) {
        Type immutableType = type.getImmutableType();
        if (immutableType != null) {
            return (BIntersectionType)immutableType;
        }
        switch (type.getTag()) {
            case 49: {
                BXmlType readonlyCommentType = new BXmlType("Comment & readonly", new Module("ballerina", "lang.xml", null), 49, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyCommentType);
            }
            case 47: {
                BXmlType readonlyElementType = new BXmlType("Element & readonly", new Module("ballerina", "lang.xml", null), 47, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyElementType);
            }
            case 48: {
                BXmlType readonlyPI = new BXmlType("ProcessingInstruction & readonly", new Module("ballerina", "lang.xml", null), 48, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyPI);
            }
            case 8: {
                BXmlType origXmlType = (BXmlType)type;
                BXmlType immutableXmlType = new BXmlType("xml & readonly", origXmlType.getPackage(), origXmlType.getTag(), true);
                immutableXmlType.constraint = ReadOnlyUtils.getImmutableType(origXmlType.constraint, unresolvedTypes);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origXmlType, immutableXmlType);
            }
            case 20: {
                BArrayType origArrayType = (BArrayType)type;
                BArrayType immutableArrayType = new BArrayType(ReadOnlyUtils.getImmutableType(origArrayType.getElementType(), unresolvedTypes), origArrayType.getSize(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origArrayType, immutableArrayType);
            }
            case 32: {
                BTupleType origTupleType = (BTupleType)type;
                List<Type> origTupleMemTypes = origTupleType.getTupleTypes();
                ArrayList<Type> immutableMemTypes = new ArrayList<Type>(origTupleMemTypes.size());
                for (Type origTupleMemType : origTupleMemTypes) {
                    immutableMemTypes.add(ReadOnlyUtils.getImmutableType(origTupleMemType, unresolvedTypes));
                }
                Type origTupleRestType = origTupleType.getRestType();
                BTupleType immutableTupleType = new BTupleType(immutableMemTypes, origTupleRestType == null ? null : ReadOnlyUtils.getImmutableType(origTupleRestType, unresolvedTypes), origTupleType.getTypeFlags(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origTupleType, immutableTupleType);
            }
            case 15: {
                BMapType origMapType = (BMapType)type;
                BMapType immutableMapType = new BMapType(ReadOnlyUtils.getImmutableType(origMapType.getConstrainedType(), unresolvedTypes), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origMapType, immutableMapType);
            }
            case 12: {
                BRecordType origRecordType = (BRecordType)type;
                Map<String, Field> originalFields = origRecordType.getFields();
                HashMap<String, Field> fields = new HashMap<String, Field>(originalFields.size());
                BRecordType immutableRecordType = new BRecordType(origRecordType.getName().concat(" & readonly"), origRecordType.getPackage(), origRecordType.flags |= 0x20L, fields, null, origRecordType.sealed, origRecordType.typeFlags);
                BIntersectionType intersectionType = ReadOnlyUtils.createAndSetImmutableIntersectionType(origRecordType, immutableRecordType);
                for (Map.Entry<String, Field> entry : originalFields.entrySet()) {
                    Field originalField = entry.getValue();
                    fields.put(entry.getKey(), new BField(ReadOnlyUtils.getImmutableType(originalField.getFieldType(), unresolvedTypes), originalField.getFieldName(), originalField.getFlags()));
                }
                Type origRecordRestFieldType = origRecordType.restFieldType;
                if (origRecordRestFieldType != null) {
                    immutableRecordType.restFieldType = ReadOnlyUtils.getImmutableType(origRecordRestFieldType, unresolvedTypes);
                }
                return intersectionType;
            }
            case 9: {
                BTableType origTableType = (BTableType)type;
                Type origKeyType = origTableType.getKeyType();
                BTableType immutableTableType = origKeyType != null ? new BTableType(ReadOnlyUtils.getImmutableType(origTableType.getConstrainedType(), unresolvedTypes), ReadOnlyUtils.getImmutableType(origKeyType, unresolvedTypes), true) : new BTableType(ReadOnlyUtils.getImmutableType(origTableType.getConstrainedType(), unresolvedTypes), origTableType.getFieldNames(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origTableType, immutableTableType);
            }
            case 35: {
                BObjectType origObjectType = (BObjectType)type;
                Map<String, Field> originalObjectFields = origObjectType.getFields();
                HashMap<String, Field> immutableObjectFields = new HashMap<String, Field>(originalObjectFields.size());
                BObjectType immutableObjectType = new BObjectType(origObjectType.getName().concat(" & readonly"), origObjectType.getPackage(), origObjectType.flags |= 0x20L);
                immutableObjectType.setFields(immutableObjectFields);
                immutableObjectType.generatedInitializer = origObjectType.generatedInitializer;
                immutableObjectType.initializer = origObjectType.initializer;
                immutableObjectType.setAttachedFunctions(origObjectType.getAttachedFunctions());
                BIntersectionType objectIntersectionType = ReadOnlyUtils.createAndSetImmutableIntersectionType(origObjectType, immutableObjectType);
                for (Map.Entry<String, Field> entry : originalObjectFields.entrySet()) {
                    Field originalField = entry.getValue();
                    immutableObjectFields.put(entry.getKey(), new BField(ReadOnlyUtils.getImmutableType(originalField.getFieldType(), unresolvedTypes), originalField.getFieldName(), originalField.getFlags()));
                }
                return objectIntersectionType;
            }
            case 7: 
            case 11: 
            case 17: {
                return (BIntersectionType)type.getImmutableType();
            }
        }
        BUnionType origUnionType = (BUnionType)type;
        ArrayList<Type> readOnlyMemTypes = new ArrayList<Type>();
        for (Type memberType : origUnionType.getMemberTypes()) {
            if (TypeChecker.isInherentlyImmutableType(memberType)) {
                readOnlyMemTypes.add(memberType);
                continue;
            }
            if (!TypeChecker.isSelectivelyImmutableType(memberType, unresolvedTypes)) continue;
            readOnlyMemTypes.add(ReadOnlyUtils.getImmutableType(memberType, unresolvedTypes));
        }
        Type resultantImmutableType = readOnlyMemTypes.size() == 1 ? (Type)readOnlyMemTypes.iterator().next() : new BUnionType(readOnlyMemTypes, true);
        return ReadOnlyUtils.createAndSetImmutableIntersectionType(origUnionType, resultantImmutableType);
    }

    private static BIntersectionType createAndSetImmutableIntersectionType(Type originalType, Type effectiveType) {
        return ReadOnlyUtils.createAndSetImmutableIntersectionType(originalType.getPackage(), originalType, effectiveType);
    }

    private static BIntersectionType createAndSetImmutableIntersectionType(Module pkg, Type originalType, Type effectiveType) {
        int typeFlags = 0;
        if (effectiveType.isAnydata()) {
            typeFlags |= 2;
        }
        if (effectiveType.isPureType()) {
            typeFlags |= 4;
        }
        if (effectiveType.isNilable()) {
            typeFlags |= 1;
        }
        BIntersectionType intersectionType = new BIntersectionType(pkg, new Type[]{originalType, PredefinedTypes.TYPE_READONLY}, effectiveType, typeFlags, true);
        originalType.setImmutableType(intersectionType);
        return intersectionType;
    }
}

