/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.RefValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.IntStream;

public class TupleValueImpl
extends AbstractArrayValue {
    protected TupleType tupleType;
    Object[] refValues;
    private int minSize = 0;
    private boolean hasRestElement;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleValueImpl that = (TupleValueImpl)o;
        return this.minSize == that.minSize && this.hasRestElement == that.hasRestElement && this.tupleType.equals(that.tupleType) && Arrays.equals(this.refValues, that.refValues);
    }

    public int hashCode() {
        int result = Objects.hash(this.tupleType, this.minSize, this.hasRestElement);
        result = 31 * result + Arrays.hashCode(this.refValues);
        return result;
    }

    @Deprecated
    public TupleValueImpl(Object[] values, TupleType type) {
        this.refValues = values;
        this.tupleType = type;
        this.hasRestElement = this.tupleType.getRestType() != null;
        List<Type> memTypes = type.getTupleTypes();
        int memCount = memTypes.size();
        if (values.length < memCount) {
            this.refValues = Arrays.copyOf(this.refValues, memCount);
            for (int i = values.length; i < memCount; ++i) {
                this.refValues[i] = memTypes.get(i).getZeroValue();
            }
        }
        this.minSize = memTypes.size();
        this.size = this.refValues.length;
    }

    @Deprecated
    public TupleValueImpl(TupleType type) {
        int memTypeCount;
        this.tupleType = type;
        List<Type> memTypes = this.tupleType.getTupleTypes();
        this.minSize = this.size = (memTypeCount = memTypes.size());
        boolean bl = this.hasRestElement = this.tupleType.getRestType() != null;
        if (type.getRestType() == null) {
            this.maxSize = this.size;
            this.refValues = new Object[this.size];
        } else {
            this.refValues = new Object[100];
        }
        for (int i = 0; i < memTypeCount; ++i) {
            Type memType = memTypes.get(i);
            if (!TypeChecker.hasFillerValue(memType)) continue;
            this.refValues[i] = memType.getZeroValue();
        }
    }

    @Deprecated
    public TupleValueImpl(TupleType type, long size, ListInitialValueEntry[] initialValues) {
        this.tupleType = type;
        List<Type> memTypes = this.tupleType.getTupleTypes();
        int memCount = memTypes.size();
        this.size = size < (long)memCount ? memCount : (int)size;
        this.minSize = memCount;
        boolean bl = this.hasRestElement = this.tupleType.getRestType() != null;
        if (type.getRestType() == null) {
            this.maxSize = this.size;
            this.refValues = new Object[this.size];
        } else {
            this.refValues = new Object[100];
        }
        for (int index = 0; index < initialValues.length; ++index) {
            this.addRefValue(index, ((ListInitialValueEntry.ExpressionEntry)initialValues[index]).value);
        }
        if (size >= (long)memCount) {
            return;
        }
        for (int i = (int)size; i < memCount; ++i) {
            Type memType = memTypes.get(i);
            if (!TypeChecker.hasFillerValue(memType)) continue;
            this.refValues[i] = memType.getZeroValue();
        }
    }

    @Override
    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.refValues[(int)index];
    }

    @Override
    public Object getRefValue(long index) {
        return this.get(index);
    }

    @Override
    public Object fillAndGetRefValue(long index) {
        if (index >= (long)this.size && this.hasRestElement) {
            this.handleImmutableArrayValue();
            this.fillRead(index, this.refValues.length);
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public long getInt(long index) {
        return (Long)this.get(index);
    }

    @Override
    public boolean getBoolean(long index) {
        return (Boolean)this.get(index);
    }

    @Override
    public byte getByte(long index) {
        return (Byte)this.get(index);
    }

    @Override
    public double getFloat(long index) {
        return (Double)this.get(index);
    }

    @Override
    @Deprecated
    public String getString(long index) {
        return this.get(index).toString();
    }

    @Override
    public BString getBString(long index) {
        return (BString)this.get(index);
    }

    @Override
    public void add(long index, Object value) {
        this.handleImmutableArrayValue();
        this.addRefValue(index, value);
    }

    private void addRefValue(long index, Object value) {
        this.prepareForAdd(index, value, this.refValues.length);
        this.refValues[(int)index] = value;
    }

    @Override
    public void add(long index, long value) {
        this.add(index, (Object)value);
    }

    @Override
    public void add(long index, boolean value) {
        this.add(index, (Object)value);
    }

    @Override
    public void add(long index, byte value) {
        this.add(index, (Object)value);
    }

    @Override
    public void add(long index, double value) {
        this.add(index, (Object)value);
    }

    @Override
    @Deprecated
    public void add(long index, String value) {
        this.add(index, (Object)value);
    }

    @Override
    public void add(long index, BString value) {
        this.add(index, (Object)value);
    }

    @Override
    public void append(Object value) {
        this.add((long)this.size, value);
    }

    @Override
    public Object shift(long index) {
        this.handleImmutableArrayValue();
        Object val = this.get(index);
        this.shiftArray((int)index);
        return val;
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(" ");
        for (int i = 0; i < this.size; ++i) {
            sj.add(StringUtils.getStringValue(this.refValues[i], new CycleUtils.Node(this, parent)));
        }
        return sj.toString();
    }

    @Override
    public String expressionStringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(" ");
        for (int i = 0; i < this.size; ++i) {
            sj.add(StringUtils.getExpressionStringValue(this.refValues[i], new CycleUtils.Node(this, parent)));
        }
        return sj.toString();
    }

    @Override
    public Type getType() {
        return this.tupleType;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public BArray slice(long startIndex, long endIndex) {
        return null;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        Object[] values = new Object[this.size];
        TupleValueImpl refValueArray = new TupleValueImpl(values, this.tupleType);
        refs.put(this, refValueArray);
        IntStream.range(0, this.size).forEach(i -> {
            Object value = this.refValues[i];
            values[i] = value instanceof RefValue ? ((RefValue)value).copy(refs) : value;
        });
        return refValueArray;
    }

    @Override
    public Object[] getValues() {
        return this.refValues;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getStringArray() {
        throw new UnsupportedOperationException();
    }

    public long[] getLongArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getIntArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serialize(OutputStream outputStream) {
        try {
            outputStream.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }

    @Override
    public void freezeDirect() {
        if (this.tupleType.isReadOnly()) {
            return;
        }
        this.tupleType = (TupleType)ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.tupleType);
        for (int i = 0; i < this.size; ++i) {
            Object value = this.get(i);
            if (!(value instanceof RefValue)) continue;
            ((RefValue)value).freezeDirect();
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    @Override
    public Type getElementType() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void resizeInternalArray(int newLength) {
        this.refValues = Arrays.copyOf(this.refValues, newLength);
    }

    @Override
    protected void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        Type restType = this.tupleType.getRestType();
        if (restType != null) {
            for (int i = this.size; i < index; ++i) {
                this.refValues[i] = restType.getZeroValue();
            }
        }
    }

    @Override
    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index < 0L || index >= (long)size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.TUPLE_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if (this.tupleType.getRestType() == null && index >= (long)this.maxSize || (int)index < 0) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.TUPLE_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void fillerValueCheck(int index, int size) {
        if (this.size >= index) {
            return;
        }
        if (!TypeChecker.hasFillerValue(this.tupleType.getRestType()) && index > size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_TUPLE_INSERTION, size, index + 1);
        }
    }

    @Override
    protected void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    @Override
    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity <= currentArraySize) {
            return;
        }
        int newArraySize = currentArraySize + (currentArraySize >> 1);
        newArraySize = Math.max(newArraySize, requestedCapacity);
        newArraySize = Math.min(newArraySize, this.maxSize);
        this.resizeInternalArray(newArraySize);
    }

    @Override
    protected void checkFixedLength(long length) {
        if (this.tupleType.getRestType() == null) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), RuntimeErrors.ILLEGAL_TUPLE_SIZE, this.size, length);
        }
        if ((long)this.tupleType.getTupleTypes().size() > length) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), RuntimeErrors.ILLEGAL_TUPLE_WITH_REST_TYPE_SIZE, this.tupleType.getTupleTypes().size(), length);
        }
    }

    @Override
    protected void unshift(long index, Object[] vals) {
        this.handleImmutableArrayValue();
        this.unshiftArray(index, vals.length, this.getCurrentArrayLength());
        this.addToRefArray(vals, (int)index);
    }

    private void prepareForAdd(long index, Object value, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        Type elemType = index >= (long)this.minSize ? this.tupleType.getRestType() : this.tupleType.getTupleTypes().get((int)index);
        if (!TypeChecker.checkIsType(value, elemType)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_TYPE, elemType, TypeChecker.getType(value)));
        }
        this.fillerValueCheck(intIndex, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    private void fillRead(long index, int currentArraySize) {
        Type restType = this.tupleType.getRestType();
        if (!TypeChecker.hasFillerValue(restType)) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_TUPLE_INSERTION, this.size, index + 1L);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        int i = this.size;
        while ((long)i <= index) {
            this.refValues[i] = restType.getZeroValue();
            ++i;
        }
        this.resetSize(intIndex);
    }

    private void shiftArray(int index) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(this.refValues, index + 1, this.refValues, index, nElemsToBeMoved);
        }
        --this.size;
    }

    private void addToRefArray(Object[] vals, int startIndex) {
        int endIndex = startIndex + vals.length;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals[j]);
            ++i;
            ++j;
        }
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int lastIndex = this.size() + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        if (index > (long)lastIndex) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        System.arraycopy(this.refValues, i, this.refValues, i + unshiftByN, this.size - i);
    }

    private int getCurrentArrayLength() {
        return this.refValues.length;
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }
}

