/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import java.util.Map;
import java.util.Objects;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMProcessingInstructionImpl;

public class XmlPi
extends XmlNonElementItem {
    private String data;
    private String target;

    public XmlPi(String data, String target) {
        this.data = data;
        this.target = target;
        this.type = PredefinedTypes.TYPE_PROCESSING_INSTRUCTION;
    }

    public XmlPi(String data, String target, boolean readonly) {
        this.data = data;
        this.target = target;
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_PROCESSING_INSTRUCTION : PredefinedTypes.TYPE_PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getTextValue() {
        return "";
    }

    public String getData() {
        return this.data;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.PI;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XmlPi(this.data, this.target);
    }

    @Override
    public OMNode value() {
        OMProcessingInstructionImpl pi = new OMProcessingInstructionImpl();
        pi.setTarget(this.target);
        pi.setValue(this.data);
        return pi;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XmlPi) {
            XmlPi that = (XmlPi)obj;
            return this.data.equals(that.data) && this.target.equals(that.target);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.target);
    }

    @Override
    public String stringValue(BLink parent) {
        return "<?" + this.target + " " + this.data + "?>";
    }
}

